/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls.table;

import java.util.function.Function;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TooltipTableRow<T>
extends TableRow<T> {
    private final @NonNull Function<T, @Nullable ObservableStringValue> tooltipMapper;
    private final @NonNull Tooltip tooltip;

    public static <T> @NonNull TooltipTableRow<T> fromUnobservable(@NonNull Function<T, @Nullable String> tooltipMapper) {
        return new TooltipTableRow<Object>(t -> {
            String text = (String)tooltipMapper.apply(t);
            if (text == null) {
                return null;
            }
            return new SimpleStringProperty(text);
        });
    }

    public TooltipTableRow(@NonNull Function<T, @Nullable ObservableStringValue> tooltipMapper) {
        this.tooltipMapper = tooltipMapper;
        this.tooltip = new Tooltip();
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setTooltip(null);
        } else {
            ObservableStringValue property = this.tooltipMapper.apply(item);
            if (property == null) {
                this.setTooltip(null);
            } else {
                this.tooltip.textProperty().unbind();
                this.tooltip.setText((String)property.get());
                this.tooltip.textProperty().bind((ObservableValue)property);
                this.setTooltip(this.tooltip);
            }
        }
    }
}

