/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls.table;

import com.arm.streamline.ui.controls.SvgImage;
import com.arm.streamline.ui.controls.table.GraphicTableCell;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javafx.scene.Node;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SvgImageTableCell<S, T>
extends GraphicTableCell<S, T> {
    public SvgImageTableCell(boolean cacheImages, @NonNull Function<T, @Nullable SvgImage> imageMapper, @NonNull Function<T, @Nullable String> textMapper, @NonNull Function<T, @Nullable String> styleClassMapper, @NonNull Function<T, @Nullable String> tooltipMapper) {
        super(new SvgImageGraphicMapper<T>(cacheImages, imageMapper), textMapper, styleClassMapper, tooltipMapper);
    }

    private static final class SvgImageGraphicMapper<T>
    implements Function<T, Node> {
        private final @NonNull Function<T, @Nullable SvgImage> imageMapper;
        private final @Nullable Map<T, @NonNull SvgImage> cache;

        public SvgImageGraphicMapper(boolean cacheImages, @NonNull Function<T, @Nullable SvgImage> imageMapper) {
            this.imageMapper = imageMapper;
            this.cache = cacheImages ? new HashMap() : null;
        }

        @Override
        public @Nullable Node apply(T t) {
            SvgImage result;
            Map<T, SvgImage> cache = this.cache;
            if (cache != null && (result = cache.get(t)) != null) {
                return result;
            }
            SvgImage image = this.imageMapper.apply(t);
            if (cache != null && image != null) {
                cache.put(t, image);
            }
            return image;
        }
    }
}

