/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls.table;

import com.arm.streamline.ui.controls.table.GraphicTableCell;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImageTableCell<S, T>
extends GraphicTableCell<S, T> {
    public ImageTableCell(boolean preserveRatio, double fitWidth, double fitHeight, @NonNull Function<T, @Nullable Image> imageMapper, @NonNull Function<T, @Nullable String> textMapper, @NonNull Function<T, @Nullable String> styleClassMapper, @NonNull Function<T, @Nullable String> tooltipMapper) {
        super(new ImageViewGraphicMapper<T>(preserveRatio, fitWidth, fitHeight, imageMapper), textMapper, styleClassMapper, tooltipMapper);
    }

    private static final class ImageViewGraphicMapper<T>
    implements Function<T, Node> {
        private final @NonNull Function<T, @Nullable Image> imageMapper;
        private final @NonNull ImageView imageView;

        public ImageViewGraphicMapper(boolean preserveRatio, double fitWidth, double fitHeight, @NonNull Function<T, @Nullable Image> imageMapper) {
            this.imageMapper = imageMapper;
            this.imageView = new ImageView();
            this.imageView.setFitHeight(fitHeight);
            this.imageView.setFitWidth(fitWidth);
            this.imageView.setPreserveRatio(preserveRatio);
        }

        @Override
        public @Nullable Node apply(T t) {
            Image image = this.imageMapper.apply(t);
            if (image != null) {
                this.imageView.setImage(image);
                return this.imageView;
            }
            this.imageView.setImage(null);
            return null;
        }
    }
}

