/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls;

import com.arm.utils.Platform;
import javafx.beans.value.ChangeListener;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FXCanvasWithMouseWheelFix
extends FXCanvas {
    private final @NonNull ChangeListener<? super Number> dimChangeListener = (p, o, n) -> FXCanvasWithMouseWheelFix.recalculateHiDPI(this.getShell(), this.getScene());
    private Listener zoomChangedListener = e -> FXCanvasWithMouseWheelFix.recalculateHiDPI(this.getShell(), this.getScene());

    private static boolean isLinuxScalingDisabled() {
        String value = System.getenv("GDK_SCALE");
        return value != null && value.equals("1");
    }

    private static double calculateScale(Point dpi, double oX, double oY) {
        double x = (double)dpi.x / 96.0 / oX;
        double y = (double)dpi.y / 96.0 / oY;
        return Math.max(x, y);
    }

    private static int getSystemFontSize(Display display, double scale) {
        int PTS_SCALER = 4;
        boolean PTS_MIN = true;
        int PTS_MAX = 256;
        int PTS_DEFAULT = 12;
        int systemFontSizeIntPts = Integer.MAX_VALUE;
        FontData[] fontDataArray = display.getSystemFont().getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontData font = fontDataArray[n2];
            systemFontSizeIntPts = Math.min(font.getHeight(), systemFontSizeIntPts);
            ++n2;
        }
        systemFontSizeIntPts = systemFontSizeIntPts != Integer.MAX_VALUE ? systemFontSizeIntPts : 12;
        return Math.max(1, Math.min(256, (int)((double)systemFontSizeIntPts * scale * 4.0 + 0.5)));
    }

    private static void recalculateHiDPI(@Nullable Shell swtShell, @Nullable Scene scene) {
        if (swtShell == null || scene == null) {
            return;
        }
        Window fxWindow = scene.getWindow();
        Display swtDisplay = swtShell.getDisplay();
        fxWindow.setForceIntegerRenderScale(false);
        fxWindow.setRenderScaleX(1.0);
        fxWindow.setRenderScaleY(1.0);
        double swtScale = Platform.isLinux() && !FXCanvasWithMouseWheelFix.isLinuxScalingDisabled() ? 1.0 : FXCanvasWithMouseWheelFix.calculateScale(swtDisplay.getDPI(), fxWindow.getOutputScaleX(), fxWindow.getOutputScaleY());
        scene.getRoot().getStyleClass().setAll((Object[])new String[]{"root", "default-size-" + FXCanvasWithMouseWheelFix.getSystemFontSize(swtDisplay, swtScale)});
    }

    public FXCanvasWithMouseWheelFix(Composite parent, int style) {
        super(parent, style);
        if (SWT.getPlatform().equals("gtk")) {
            this.getDisplay().addFilter(48, ge -> {
                ge.type = 0;
            });
        }
    }

    public void setScene(Scene scene) {
        Shell shell = this.getShell();
        Scene oldScene = super.getScene();
        super.setScene(scene);
        if (oldScene != null) {
            shell.removeListener(55, this.zoomChangedListener);
            oldScene.widthProperty().removeListener(this.dimChangeListener);
            oldScene.heightProperty().removeListener(this.dimChangeListener);
        }
        if (scene != null) {
            String baseStyleSheet = FXCanvasWithMouseWheelFix.isDarkModeUI() ? "/resources/scss/dark/streamline.css" : "/resources/scss/light/streamline.css";
            scene.setUserAgentStylesheet(FXCanvasWithMouseWheelFix.class.getResource(baseStyleSheet).toString());
            scene.widthProperty().addListener(this.dimChangeListener);
            scene.heightProperty().addListener(this.dimChangeListener);
            FXCanvasWithMouseWheelFix.recalculateHiDPI(this.getShell(), scene);
            shell.addListener(55, this.zoomChangedListener);
        }
    }

    private static int getPerceivedBrightness(Color colour) {
        RGB rgb = colour.getRGB();
        return (int)Math.sqrt((double)(rgb.red * rgb.red) * 0.21 + (double)(rgb.green * rgb.green) * 0.72 + (double)(rgb.blue * rgb.blue) * 0.07);
    }

    private static boolean isDarkModeUI() {
        int fgBrightness;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Color background = display.getSystemColor(22);
        Color foreground = display.getSystemColor(21);
        int bgBrightness = FXCanvasWithMouseWheelFix.getPerceivedBrightness(background);
        return bgBrightness - (fgBrightness = FXCanvasWithMouseWheelFix.getPerceivedBrightness(foreground)) < 0;
    }
}

