/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.spe.decoders;

import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.spe.decoders.ISpePacketConsumer;
import com.arm.streamline.spe.decoders.ISpeRecord;
import com.arm.streamline.spe.decoders.SpeDecodeException;
import com.arm.utils.function.IThrowingConsumer;
import gnu.trove.TCollections;
import gnu.trove.map.TByteShortMap;
import gnu.trove.map.hash.TByteShortHashMap;
import gnu.trove.set.TShortSet;
import gnu.trove.set.hash.TShortHashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SpeRecordDecoder<T extends Throwable>
implements ISpePacketConsumer<T> {
    private @NonNull CurrentState currentState = new CurrentState();
    private final @NonNull IThrowingConsumer<@NonNull ISpeRecord, T> recordConsumer;

    public static @NonNull SpeDecodeException valueMoreThanOnce(@NonNull String thing) {
        return new SpeDecodeException(SpeDecodeException.Reason.VALUE_PRESENT_MORE_THAN_ONCE, thing + " present more than once.");
    }

    public static @NonNull SpeDecodeException valueMissing(@NonNull String thing) {
        return new SpeDecodeException(SpeDecodeException.Reason.VALUE_MISSING, thing + " not present.");
    }

    public SpeRecordDecoder(@NonNull IThrowingConsumer<@NonNull ISpeRecord, T> recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    @Override
    public void addressPacket(byte index, long payload) throws SpeDecodeException {
        if (index == 0) {
            if (this.currentState.pc == null) {
                long address = payload & 0xFFFFFFFFFFFFFFL;
                long signExtension = (payload & 0x80000000000000L) != 0L ? -72057594037927936L : 0L;
                this.currentState.pc = address | signExtension;
            } else {
                throw SpeRecordDecoder.valueMoreThanOnce("PC");
            }
        }
    }

    @Override
    public void contextPacket(@NonNull ISpePacketConsumer.ContextId id, int context) throws SpeDecodeException {
    }

    @Override
    public void counterPacket(byte index, short count) throws SpeDecodeException {
        if (this.currentState.counterMap.containsKey(index)) {
            throw SpeRecordDecoder.valueMoreThanOnce("Counter " + index);
        }
        this.currentState.counterMap.put(index, count);
    }

    @Override
    public void dataSourcePacket(short source) throws SpeDecodeException {
        if (!this.currentState.dataSources.add(source)) {
            throw SpeRecordDecoder.valueMoreThanOnce("Data Source " + source);
        }
    }

    @Override
    public void endPacket() throws T, SpeDecodeException {
        @Nullable Long events = this.currentState.events;
        if (events == null) {
            throw SpeRecordDecoder.valueMissing("Events");
        }
        SpeRecord record = new SpeRecord(this.currentState.timestamp, this.currentState.operationType, this.currentState.pc, events, this.currentState.dataSources, this.currentState.counterMap);
        this.currentState = new CurrentState();
        this.recordConsumer.accept((Object)record);
    }

    @Override
    public void eventsPacket(long events) throws SpeDecodeException {
        if (this.currentState.events != null) {
            throw SpeRecordDecoder.valueMoreThanOnce("Events");
        }
        this.currentState.events = events;
    }

    @Override
    public void operationTypePacket(@NonNull SpeOperationTypeClass clazz, byte subclazz) throws SpeDecodeException {
        if (this.currentState.operationType != null) {
            throw SpeRecordDecoder.valueMoreThanOnce("Operation type");
        }
        this.currentState.operationType = new ISpeRecord.OperationType(clazz, subclazz);
    }

    @Override
    public void timestampPacket(long timestamp) throws T, SpeDecodeException {
        this.currentState.timestamp = timestamp;
        this.endPacket();
    }

    @Override
    public void unknownPacket() throws SpeDecodeException {
        assert (false) : "We should know every packet type";
    }

    private static final class CurrentState {
        public final @NonNull TByteShortMap counterMap = new TByteShortHashMap();
        public final @NonNull TShortSet dataSources = new TShortHashSet();
        public @Nullable Long events;
        public @Nullable ISpeRecord.OperationType operationType;
        public @Nullable Long pc;
        public @Nullable Long timestamp;
    }

    private static final class SpeRecord
    implements ISpeRecord {
        private final @NonNull TByteShortMap counterMap;
        private final @NonNull TShortSet dataSources;
        private final long events;
        private final @Nullable ISpeRecord.OperationType operationType;
        private final @Nullable Long pc;
        private final @Nullable Long timestamp;

        public SpeRecord(@Nullable Long timestamp, @Nullable ISpeRecord.OperationType operationType, @Nullable Long pc, long events, @NonNull TShortSet dataSources, @NonNull TByteShortMap counterMap) {
            this.timestamp = timestamp;
            this.operationType = operationType;
            this.pc = pc;
            this.events = events;
            this.dataSources = dataSources;
            this.counterMap = counterMap;
        }

        @Override
        public @NonNull TByteShortMap getCounterMap() {
            return TCollections.unmodifiableMap((TByteShortMap)this.counterMap);
        }

        @Override
        public @NonNull TShortSet getDataSources() {
            return TCollections.unmodifiableSet((TShortSet)this.dataSources);
        }

        @Override
        public long getEvents() {
            return this.events;
        }

        @Override
        public @Nullable ISpeRecord.OperationType getOperationType() {
            return this.operationType;
        }

        @Override
        public @Nullable Long getPc() {
            return this.pc;
        }

        @Override
        public @Nullable Long getTimestamp() {
            return this.timestamp;
        }
    }
}

