/*
 * Decompiled with CFR 0.152.
 */
package com.arm.armnn.timeline;

import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

class StreamMetadata {
    static final int LITTLE_ENDIAN = 0;
    static final int BIG_ENDIAN = 1;
    private final @NonNull ByteOrder mEndianness;
    private final int mPid;
    private final int mTimelineDirectoryPacketVersion;
    private final int mTimelineDataPacketVersion;

    StreamMetadata(@NonNull ByteOrder endianness, int pid, int timelineDirectoryVersion, int timelineDataVersion) {
        this.mEndianness = endianness;
        this.mPid = pid;
        this.mTimelineDirectoryPacketVersion = timelineDirectoryVersion;
        this.mTimelineDataPacketVersion = timelineDataVersion;
    }

    public @NonNull ByteOrder getEndianness() {
        return this.mEndianness;
    }

    public int getEndiannessAsInt() {
        return this.mEndianness.equals(ByteOrder.LITTLE_ENDIAN) ? 0 : 1;
    }

    public int getPid() {
        return this.mPid;
    }

    public int getTimelineDirectoryPacketVersion() {
        return this.mTimelineDirectoryPacketVersion;
    }

    public int getTimelineDataPacketVersion() {
        return this.mTimelineDataPacketVersion;
    }
}

