/*
 * Decompiled with CFR 0.152.
 */
package javafx.all;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static void doLog(ILog log, int level, String id, String message) {
        log.log((IStatus)new Status(level, id, message));
    }

    private static void extractAllBundleEntries(ILog log, String id, Enumeration<URL> bundleUrls) throws IOException {
        if (bundleUrls == null) {
            return;
        }
        URL url = bundleUrls.nextElement();
        while (bundleUrls.hasMoreElements()) {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            Activator.doLog(log, 1, id, String.format("Extracting bundle url '%s' to '%s'", url, fileUrl));
            url = bundleUrls.nextElement();
        }
    }

    private static void loadAllBundleEntries(ILog log, String id, Enumeration<URL> bundleUrls) throws IOException {
        File file;
        if (bundleUrls == null) {
            return;
        }
        HashSet<File> libraryFiles = new HashSet<File>();
        URL url = bundleUrls.nextElement();
        while (bundleUrls.hasMoreElements()) {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            file = new File(fileUrl.getPath());
            libraryFiles.add(file);
            Activator.doLog(log, 1, id, String.format("Extracting bundle url '%s' to '%s', which is '%s'", url, fileUrl, file));
            if (!file.exists()) {
                Activator.doLog(log, 4, id, String.format("File '%s' does not exist, crash expected.", file));
            }
            url = bundleUrls.nextElement();
        }
        while (!libraryFiles.isEmpty()) {
            boolean anySucceeded = false;
            Iterator it = libraryFiles.iterator();
            while (it.hasNext()) {
                file = (File)it.next();
                try {
                    System.load(file.getAbsolutePath());
                    anySucceeded = true;
                    it.remove();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            if (anySucceeded) continue;
            Activator.doLog(log, 4, id, String.format("Failed to load the following native libraries. Crash expected. %s", libraryFiles.stream().sorted().map(File::getName).collect(Collectors.joining(", ", "", ""))));
            break;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Bundle bundle = context.getBundle();
        ILog log = this.getLog();
        String id = bundle.getSymbolicName();
        switch (Platform.getOS()) {
            case "linux": {
                Enumeration allLinuxSoUrls = bundle.findEntries("/", "*.so", true);
                Activator.extractAllBundleEntries(log, id, allLinuxSoUrls);
                break;
            }
            case "macosx": {
                Enumeration allMacDylibsUrls = bundle.findEntries("/", "*.dylib", true);
                Activator.extractAllBundleEntries(log, id, allMacDylibsUrls);
                break;
            }
            case "win32": {
                Enumeration allWin32DllUrls = bundle.findEntries("/", "*.dll", true);
                Activator.loadAllBundleEntries(log, id, allWin32DllUrls);
                break;
            }
            default: {
                Activator.doLog(log, 2, id, String.format("Unrecognised OS '%s'", Platform.getOS()));
            }
        }
    }
}

