/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.dtsl.decoders.stm.stpprotocol;

import com.arm.debug.dtsl.decoders.stm.stpprotocol.Messages;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPNibbleQueue;

public class STPDecodeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Cause cause;
    private byte[] packetContent;
    private int packetNibbleLength;

    public STPDecodeException(Cause cause) {
        this.cause = cause;
        this.packetContent = null;
        this.packetNibbleLength = 0;
    }

    public void setPacketContent(byte[] packetContent, int packetNibbleLength) {
        this.packetContent = (byte[])packetContent.clone();
        this.packetNibbleLength = packetNibbleLength;
    }

    public Cause getCauseCode() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        Object errStr = "";
        switch (this.cause) {
            case OutOfData: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.OutOfData");
                break;
            }
            case UnknownPacketType: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.UnknownPacketType");
                break;
            }
            case MalformedPacket: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.MalformedPacket");
                break;
            }
            case PacketTooLong: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.PacketTooLong");
                break;
            }
            case UnsupportedProtocolVersion: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.UnsupportedProtocolVersion");
                break;
            }
            case BadTimestamp: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.BadTimestamp");
                break;
            }
            case TimestampPriorToVersion: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.TimestampPriorToVersion");
                break;
            }
            case InternalBufferOverflow: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.InternalBufferOverflow");
                break;
            }
            case BadAsyncPacket: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.BadAsyncPacket");
                break;
            }
            default: {
                errStr = (String)errStr + Messages.getString("STPDecodeException.UnknownCause");
            }
        }
        if (this.packetContent != null) {
            STPNibbleQueue nq = new STPNibbleQueue();
            nq.appendData(this.packetContent, this.packetNibbleLength);
            errStr = (String)errStr + " : " + nq.toString();
        }
        return errStr;
    }

    public static enum Cause {
        OutOfData,
        UnknownPacketType,
        MalformedPacket,
        PacketTooLong,
        UnsupportedProtocolVersion,
        TimestampPriorToVersion,
        BadTimestamp,
        InternalBufferOverflow,
        BadAsyncPacket;

    }
}

