/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.dtsl.decoders.stm.stpprotocol;

import java.util.Formatter;

public class NibbleData {
    protected int nibbleCount;
    protected byte[] data;

    public NibbleData(int nibbleCount, byte[] data) {
        this.nibbleCount = nibbleCount;
        this.data = data;
    }

    public int getNibbleCount() {
        return this.nibbleCount;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getNibbleData() {
        byte[] nibbleData = new byte[this.nibbleCount];
        int bIdx = 0;
        int nIdx = 0;
        int bCount = this.nibbleCount / 2;
        while (bCount-- > 0) {
            nibbleData[nIdx++] = (byte)(this.data[bIdx] >> 4 & 0xF);
            nibbleData[nIdx++] = (byte)(this.data[bIdx] & 0xF);
            ++bIdx;
        }
        if (nIdx < this.nibbleCount) {
            nibbleData[nIdx] = (byte)(this.data[bIdx] & 0xF);
        }
        return nibbleData;
    }

    public byte getWord8() {
        return this.getWord8(0);
    }

    public byte getWord8(int idxOffset) {
        if (this.data == null || 2 * idxOffset >= this.nibbleCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[idxOffset];
    }

    public int getWord16() {
        return this.getWord16(0);
    }

    public int getWord16(int idxOffset) {
        if (this.data == null || 2 * idxOffset >= this.nibbleCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int shift = 0;
        int result = 0;
        int nibblesLeft = this.nibbleCount - 2 * idxOffset;
        while (shift < 2 && nibblesLeft > 0) {
            int tmpVal = this.data[idxOffset++] & 0xFF;
            result |= tmpVal << 8 * shift++;
            nibblesLeft -= 2;
        }
        return result;
    }

    public int getWord32() {
        return this.getWord32(0);
    }

    public int getWord32(int idxOffset) {
        if (this.data == null || 2 * idxOffset >= this.nibbleCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int shift = 0;
        int result = 0;
        int nibblesLeft = this.nibbleCount - 2 * idxOffset;
        while (shift < 4 && nibblesLeft > 0) {
            int tmpVal = this.data[idxOffset++] & 0xFF;
            result |= tmpVal << 8 * shift++;
            nibblesLeft -= 2;
        }
        return result;
    }

    public long getWord64() {
        return this.getWord64(0);
    }

    public long getWord64(int idxOffset) {
        if (this.data == null || idxOffset >= this.nibbleCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int shift = 0;
        long result = 0L;
        int nibblesLeft = this.nibbleCount - 2 * idxOffset;
        while (shift < 8 && nibblesLeft > 0) {
            long tmpVal = this.data[idxOffset++] & 0xFF;
            result |= tmpVal << 8 * shift++;
            nibblesLeft -= 2;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Formatter formatter = new Formatter(sb);){
            switch (this.nibbleCount) {
                case 1: {
                    formatter.format("0x%1X", this.getWord8());
                    return sb.toString();
                }
                case 2: {
                    formatter.format("0x%02X", this.getWord8());
                    return sb.toString();
                }
                case 4: {
                    formatter.format("0x%04X", this.getWord16());
                    return sb.toString();
                }
                case 8: {
                    formatter.format("0x%08X", this.getWord32());
                    return sb.toString();
                }
                case 16: {
                    formatter.format("0x%016X", this.getWord64());
                    return sb.toString();
                }
                default: {
                    int idx = 0;
                    while (idx < this.nibbleCount) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append("%x");
                        sb.append(Integer.toHexString(this.data[idx / 2] >> 4 * (idx & 1) & 0xF).toUpperCase());
                        ++idx;
                    }
                    return sb.toString();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            } else {
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

