/*
 * Decompiled with CFR 0.152.
 */
package com.arm.coresight.ds5_trace_dump;

import com.arm.coresight.ds5_trace_dump.ITMTraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceDumpTraceStream;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.STMTraceSourceStreamWrapper;
import com.arm.ini.IniFile;
import com.arm.ini.IniFileParser;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicNumberUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceDumpDirectory
implements ITraceDumpDirectory {
    private static final Pattern BUFFER_KEY_NAME_PATTERN = Pattern.compile("buffer(\\d+)");
    private static final @NonNull String CONTENTS_INI_FILENAME = "contents.ini";
    private static final @NonNull String CONTENTS_TRACE_METADATA_KEY_NAME = "metadata";
    private static final @NonNull String CONTENTS_TRACE_SECTION_NAME = "trace";
    private static final Pattern DATA_FILENAME_PATTERN = Pattern.compile("_DATA_\\d(\\..+)?$");
    private static final @NonNull String METADATA_TRACE_BUFFER_SECTION_FORMAT_KEY_NAME = "format";
    private static final @NonNull String METADATA_TRACE_BUFFER_SECTION_FORMAT_SOURCE_DATA_VALUE = "source_data";
    private static final @NonNull String METADATA_TRACE_BUFFER_SECTION_SOURCES_KEY_NAME = "sources";
    private static final @NonNull String METADATA_TRACE_SOURCE_SECTION_FORMAT_KEY_NAME = "format";
    private static final @NonNull String METADATA_TRACE_SOURCE_SECTION_NAME_KEY_NAME = "name";
    private static final @NonNull String DSTREAM_PREFIX = "DSTREAM_";
    private final @NonNull IniFile contentsIni;
    private @NonNull File directory;
    private final @NonNull IniFile traceIni;
    private final @NonNull Map<String, TraceStream> traceStreams = new HashMap<String, TraceStream>();

    private static @NonNull Map<String, List<File>> collectBufferFilesFromContents(@NonNull File directory, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IniFile.Section contentsTraceSection) throws FileNotFoundException {
        HashMap<String, List<File>> result = new HashMap<String, List<File>>();
        for (String key : contentsTraceSection.keys()) {
            String propertyValue;
            Matcher matcher = BUFFER_KEY_NAME_PATTERN.matcher(key);
            if (!matcher.matches() || (propertyValue = contentsTraceSection.property(key)) == null || propertyValue.isEmpty()) continue;
            String[] fileNames = propertyValue.split(",");
            ArrayList<File> files = new ArrayList<File>();
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (!(fileName = fileName.trim()).startsWith(DSTREAM_PREFIX) && !fileName.isEmpty()) {
                    File bufferFile = new File(directory, fileName);
                    if (!(bufferFile.exists() && bufferFile.isFile() && bufferFile.canRead())) {
                        throw new FileNotFoundException(String.format("'%s' is not found/accessible", bufferFile));
                    }
                    files.add(bufferFile);
                }
                ++n2;
            }
            result.put(key, files);
        }
        return result;
    }

    private static @NonNull Map<String, // Could not load outer class - annotation placement on inner may be incorrect
    IniFile.Section> getBufferSourceSections(@NonNull Collection<String> bufferKeys, @NonNull IniFile traceIni) throws IOException {
        HashMap<String, IniFile.Section> result = new HashMap<String, IniFile.Section>();
        for (String key : bufferKeys) {
            String sourcesValue;
            IniFile.Section bufferSection = traceIni.section(key);
            if (bufferSection == null) {
                throw new IOException(String.format("Missing [%s] section in metadata file", key));
            }
            String formatValue = bufferSection.property("format");
            if (formatValue == null || !formatValue.equals(METADATA_TRACE_BUFFER_SECTION_FORMAT_SOURCE_DATA_VALUE) || (sourcesValue = bufferSection.property(METADATA_TRACE_BUFFER_SECTION_SOURCES_KEY_NAME)) == null) continue;
            IniFile.Section sourcesSection = traceIni.section(sourcesValue);
            if (sourcesSection == null) {
                throw new IOException(String.format("Missing [%s] section in metadata file", sourcesValue));
            }
            result.put(key, sourcesSection);
        }
        return result;
    }

    private static @NonNull IniFile getContentsIni(@NonNull File directory) throws IOException {
        File contentsFile = new File(directory, CONTENTS_INI_FILENAME);
        if (!(contentsFile.exists() && contentsFile.isFile() && contentsFile.canRead())) {
            throw new FileNotFoundException(String.format("'%s' is not found/accessible", contentsFile));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream contentsFileStream = new FileInputStream(contentsFile);){
            return (IniFile)NullChecking.neverNull((Object)IniFileParser.parse((InputStream)contentsFileStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IniFile.Section getContentsIniTraceSection(@NonNull IniFile contentsIni) throws IOException {
        IniFile.Section contentsTraceSection = contentsIni.section(CONTENTS_TRACE_SECTION_NAME);
        if (contentsTraceSection == null) {
            throw new IOException(String.format("Invalid contents - missing [%s] section in %s", CONTENTS_TRACE_SECTION_NAME, CONTENTS_INI_FILENAME));
        }
        return contentsTraceSection;
    }

    private static @NonNull IniFile getTraceIni(@NonNull File directory, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IniFile.Section contentsTraceSection) throws IOException {
        String metadataFileName = contentsTraceSection.property(CONTENTS_TRACE_METADATA_KEY_NAME);
        if (metadataFileName == null) {
            throw new IOException(String.format("Missing %s property in %s", CONTENTS_TRACE_METADATA_KEY_NAME, CONTENTS_INI_FILENAME));
        }
        File metadataFile = new File(directory, metadataFileName);
        if (!(metadataFile.exists() && metadataFile.isFile() && metadataFile.canRead())) {
            throw new FileNotFoundException(String.format("'%s' is not found/accessible", metadataFile));
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream metadataFileStream = new FileInputStream(metadataFile);){
            return (IniFile)NullChecking.neverNull((Object)IniFileParser.parse((InputStream)metadataFileStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static @Nullable ITraceSourceStreamWrapper wrapTraceStream(@NonNull TraceStream traceStream) {
        ITraceSourceStreamWrapper result = ITMTraceSourceStreamWrapper.tryCreateITMTraceStream(traceStream);
        if (result == null) {
            result = STMTraceSourceStreamWrapper.tryCreateSTMTraceStream(traceStream);
        }
        return result;
    }

    public TraceDumpDirectory(@NonNull File directory) throws IOException {
        this.directory = directory = (File)NullChecking.neverNull((Object)directory.getCanonicalFile());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new FileNotFoundException(String.format("'%s' is not a valid directory path", directory));
        }
        this.contentsIni = TraceDumpDirectory.getContentsIni(directory);
        IniFile.Section contentsTraceSection = TraceDumpDirectory.getContentsIniTraceSection(this.contentsIni);
        Map<String, List<File>> buffers = TraceDumpDirectory.collectBufferFilesFromContents(directory, contentsTraceSection);
        this.traceIni = TraceDumpDirectory.getTraceIni(directory, contentsTraceSection);
        Map<String, IniFile.Section> bufferSourceSections = TraceDumpDirectory.getBufferSourceSections((Collection)NullChecking.neverNull(buffers.keySet()), this.traceIni);
        for (Map.Entry<String, IniFile.Section> bufferSourceSectionsEntry : bufferSourceSections.entrySet()) {
            int filesLength;
            String key = bufferSourceSectionsEntry.getKey();
            IniFile.Section section = (IniFile.Section)NullChecking.neverNull((Object)bufferSourceSectionsEntry.getValue());
            List files = (List)NullChecking.neverNull(buffers.get(key));
            String sourceName = section.property(METADATA_TRACE_SOURCE_SECTION_NAME_KEY_NAME);
            String sourceFormat = section.property("format");
            if (sourceName == null || sourceFormat == null || (filesLength = files.size()) == 0) continue;
            boolean allData = false;
            int i = 0;
            while (i < filesLength) {
                File file = (File)files.get(i);
                Matcher matcher = DATA_FILENAME_PATTERN.matcher(file.getName());
                boolean isData = matcher.find();
                if (i > 0) {
                    if (isData != allData) {
                        throw new AssertionError((Object)String.format("Mixed data and instruction file names list %s", files));
                    }
                } else {
                    allData = isData;
                }
                this.addTraceStreamFile(file, sourceName, sourceFormat, allData, section);
                ++i;
            }
        }
    }

    @Override
    public List<@NonNull ITraceSourceStreamWrapper> getAllTraceSourceStreamWrappers() {
        return this.getAllTraceSourceStreamWrappers(s -> true);
    }

    @Override
    public List<@NonNull ITraceSourceStreamWrapper> getAllTraceSourceStreamWrappers(Predicate<@NonNull ITraceSourceStreamWrapper> filter) {
        return this.traceStreams.values().stream().map(s -> TraceDumpDirectory.wrapTraceStream(s)).filter(s -> s != null && filter.test((ITraceSourceStreamWrapper)s)).collect(Collectors.toList());
    }

    @Override
    public String getContentsIniProperty(String sectionName, String keyName) {
        IniFile.Section section = this.contentsIni.section(sectionName);
        if (section == null) {
            return null;
        }
        return section.property(keyName);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getMetadataProperty(String sectionName, String keyName) {
        IniFile.Section section = this.traceIni.section(sectionName);
        if (section == null) {
            return null;
        }
        return section.property(keyName);
    }

    public Map<String, TraceStream> getTraceStreams() {
        return Collections.unmodifiableMap(this.traceStreams);
    }

    private void addTraceStreamFile(@NonNull File file, @NonNull String streamName, @NonNull String streamFormat, boolean secondary, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IniFile.Section section) throws IOException {
        TraceStream bufferStream = this.traceStreams.get(streamName);
        if (bufferStream != null) {
            if (bufferStream.getSection() != section) {
                throw new IOException("Multipart trace stream associated with multiple trace sources");
            }
        } else {
            bufferStream = new TraceStream(this, streamName, streamFormat, section);
            this.traceStreams.put(streamName, bufferStream);
        }
        bufferStream.add(secondary, file);
    }

    public static class TraceStream
    implements ITraceDumpTraceStream {
        private static final @NonNull String CORE_KEY_NAME = "core";
        private static final Pattern REGISTER_KEY_PATTERN = Pattern.compile("([^(]+)\\(((?:\\d+)|(?:0[xX][0-9A-Fa-f]+))\\)");
        private final @NonNull List<@NonNull File> primaryStreamFileSections = new ArrayList<File>();
        private final @NonNull Map<String, Long> registerPropertiesByName = new HashMap<String, Long>();
        private final @NonNull TIntObjectMap<Long> registerPropertiesByOffset = new TIntObjectHashMap(10, 0.5f, Integer.MIN_VALUE);
        private final @NonNull List<@NonNull File> secondaryStreamFileSections = new ArrayList<File>();
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IniFile.Section section;
        private final @NonNull String streamFormat;
        private final @NonNull String streamName;
        private final @NonNull TraceDumpDirectory traceDumpDirectory;

        public TraceStream(@NonNull TraceDumpDirectory traceDumpDirectory, @NonNull String streamName, @NonNull String streamFormat, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IniFile.Section section) {
            this.traceDumpDirectory = traceDumpDirectory;
            this.streamName = streamName;
            this.streamFormat = streamFormat;
            this.section = section;
            for (String key : section.keys()) {
                Matcher matcher = REGISTER_KEY_PATTERN.matcher(key);
                if (!matcher.matches()) continue;
                String registerName = (String)NullChecking.neverNull((Object)matcher.group(1));
                String address = (String)NullChecking.neverNull((Object)matcher.group(2));
                String valueString = section.property(key);
                if (valueString == null) continue;
                Long value = BasicNumberUtils.decodeUnsignedLong((String)valueString);
                this.registerPropertiesByName.put(registerName.toUpperCase(), value);
                this.registerPropertiesByOffset.put(Integer.decode(address).intValue(), (Object)value);
            }
        }

        @Override
        public List<@NonNull File> getPrimaryStreamFiles() {
            return Collections.unmodifiableList(this.primaryStreamFileSections);
        }

        public @Nullable Long getRegisterProperty(int offset) {
            return (Long)this.registerPropertiesByOffset.get(offset);
        }

        public @Nullable Long getRegisterProperty(@NonNull String name) {
            Long result = this.registerPropertiesByName.get(name.toUpperCase());
            if (result != null) {
                return result;
            }
            String property = this.section.property(name);
            if (property != null) {
                try {
                    return BasicNumberUtils.decodeUnsignedLong((String)property);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public @NonNull List<@NonNull File> getSecondaryStreamFiles() {
            return Collections.unmodifiableList(this.secondaryStreamFileSections);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IniFile.Section getSection() {
            return this.section;
        }

        @Override
        public @Nullable String getSourceCore() {
            return this.section.property(CORE_KEY_NAME);
        }

        @Override
        public @NonNull String getSourceFormat() {
            return this.streamFormat;
        }

        @Override
        public @NonNull String getStreamName() {
            return this.streamName;
        }

        @Override
        public @NonNull ITraceDumpDirectory getTraceDumpDirectory() {
            return this.traceDumpDirectory;
        }

        public @Nullable Long optionalRegister(@NonNull String regName, int offset) {
            Long result = this.getRegisterProperty(regName);
            if (result != null) {
                return result;
            }
            result = this.getRegisterProperty(offset);
            if (result != null) {
                return result;
            }
            return null;
        }

        public long optionalRegister(@NonNull String regName, int offset, long defaultValue) {
            Long result = this.optionalRegister(regName, offset);
            if (result == null) {
                return defaultValue;
            }
            return result;
        }

        public long requireRegister(@NonNull String regName, int offset) {
            Long result = this.optionalRegister(regName, offset);
            if (result == null) {
                throw new AssertionError((Object)String.format("Could not find register value property %s(0x%x)", regName, offset));
            }
            return result;
        }

        private void add(boolean secondary, @NonNull File file) {
            List<@NonNull File> listToUse = !secondary ? this.primaryStreamFileSections : this.secondaryStreamFileSections;
            listToUse.add(file);
        }
    }
}

