/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.pass_two;

import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.barman.pass_two.BarmanUniqueProcess;
import com.arm.streamline.barman.pass_two.BarmanUniqueThread;
import com.arm.utils.NullChecking;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BarmanUniqueProcessThread
extends BarmanUniqueThread {
    private final @Nullable IExecutablePath executablePath;
    private final @NonNull List<@NonNull ExecutablePathMapping> mmaps;
    private final @NonNull BarmanUniqueProcess uniqueProcess;
    private final long vmUID;

    public BarmanUniqueProcessThread(int uid, int processUID, long vmUID, long timestamp, int taskId, @Nullable String name, @Nullable List<@NonNull ExecutablePathMapping> mmaps, @Nullable IExecutablePath executablePath, boolean idle) {
        super(uid, timestamp, taskId, name, idle);
        assert (idle || executablePath != IExecutablePath.IDLE);
        this.vmUID = vmUID;
        this.mmaps = mmaps != null ? mmaps : Collections.emptyList();
        this.executablePath = executablePath != IExecutablePath.IDLE ? executablePath : IExecutablePath.KERNEL;
        this.uniqueProcess = new BarmanUniqueProcess(processUID, this);
    }

    public @NonNull BarmanUniqueProcess asUniqueProcess() {
        return this.uniqueProcess;
    }

    public @Nullable ExecutablePathMapping findMMapping(long address) {
        return ExecutablePathMapping.findMMapping(this.mmaps, (long)address);
    }

    public @Nullable IExecutablePath getExecutablePath() {
        return this.executablePath;
    }

    public @NonNull List<@NonNull ExecutablePathMapping> getMMaps() {
        return Collections.unmodifiableList(this.mmaps);
    }

    @Override
    public @NonNull BarmanUniqueProcessThread getProcessThread() {
        return this;
    }

    public long getVmUID() {
        return this.vmUID;
    }

    @Override
    public boolean hasMMaps() {
        return !this.mmaps.isEmpty();
    }

    public boolean isKernel() {
        return this.executablePath == IExecutablePath.KERNEL;
    }

    public boolean isProcessThread() {
        return true;
    }

    @Override
    public String toString() {
        return String.format("BarmanUniqueProcessThread [uid=%s, vmUID=%s, taskId=%s, name=%s, earliestSeenTimestamp=%s, lastSeenTimestamp=%s, executablePath=%s, mmaps=%s]", this.getUID(), this.vmUID, this.getOriginalID(), this.getName(), this.getEarliestSeenTimestamp(), this.getLastSeenTimestamp(), this.executablePath, this.mmaps);
    }

    @Override
    protected boolean equalsChild(@NonNull BarmanUniqueThread obj) {
        if (obj instanceof BarmanUniqueProcessThread) {
            BarmanUniqueProcessThread that = (BarmanUniqueProcessThread)obj;
            return this.vmUID == that.vmUID && this.mmaps.equals(that.mmaps) && NullChecking.equalsNullable((Object)this.executablePath, (Object)that.executablePath);
        }
        return false;
    }
}

