/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.IBarmanProcessorInformation;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.MIDRUtilities;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.utils.NullChecking;
import gnu.trove.TCollections;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanClustersInfo
implements IClustersInfo {
    private static final @NonNull String MULTI_NAME_SEPARATOR = " / ";
    private static final @NonNull String MULTI_PNMC_NAME_SEPARATOR = "__";
    private final boolean mBigLITTLE;
    private final @NonNull TIntObjectMap<TIntList> mClusterCores;
    private final @NonNull TIntObjectMap<String> mClusterHumanNames;
    private final @NonNull TIntObjectMap<TIntSet> mClusterMidrs;
    private final @NonNull TIntObjectMap<String> mClusterPmncNames;
    private final @NonNull TIntIntMap mCpuClusterIds;
    private final int mMaxProcessorId;
    private final @NonNull TIntObjectMap<IBarmanProcessorInformation> mProcessors = new TIntObjectHashMap(10, 0.5f, -1);

    public static @NonNull ProcessorPmu getFakeProcessorPmu(int midr) {
        int implementer = MIDRUtilities.getImplementer((int)midr);
        int variant = MIDRUtilities.getVariant((int)midr);
        int architecture = MIDRUtilities.getArchitecture((int)midr);
        int partNum = MIDRUtilities.getPartNum((int)midr);
        int revision = MIDRUtilities.getRevision((int)midr);
        int cpuid = MIDRUtilities.makeGatorCpuid((int)midr);
        String implementerName = MIDRUtilities.getImplementerName((int)implementer);
        String architectureName = MIDRUtilities.getArchitectureName((int)architecture);
        if (implementerName == null) {
            String id = (String)NullChecking.neverNull((Object)String.format("%s_Unknown%02x_%x_%03x_%x", architectureName, implementer, variant, partNum, revision));
            String name = (String)NullChecking.neverNull((Object)String.format("%s Unknown (%02x) %x-%03x-%x", architectureName, implementer, variant, partNum, revision));
            return new ProcessorPmu(id, id, name, new int[]{cpuid}, 32, (Map)NullChecking.neverNull(Collections.emptyMap()), ProcessorPmu.ArchitectureProfile.UNKNOWN);
        }
        String id = (String)NullChecking.neverNull((Object)String.format("%s_%s_%x_%03x_%x", architectureName, implementerName, variant, partNum, revision));
        String name = (String)NullChecking.neverNull((Object)String.format("%s %s %x-%03x-%x", architectureName, implementerName, variant, partNum, revision));
        return new ProcessorPmu(id, id, name, new int[]{cpuid}, 32, (Map)NullChecking.neverNull(Collections.emptyMap()), ProcessorPmu.ArchitectureProfile.UNKNOWN);
    }

    private static @NonNull ProcessorPmu getProcessorName(@NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> pmus, int midr) {
        int cpuid = MIDRUtilities.makeGatorCpuid((int)midr);
        ProcessorPmu pmu = pmus.get(cpuid);
        if (pmu != null) {
            return pmu;
        }
        return BarmanClustersInfo.getFakeProcessorPmu(midr);
    }

    private static @NonNull ProcessorPmu makeClusterName(@NonNull Set<@NonNull ProcessorPmu> names) {
        assert (names.size() > 0);
        if (names.size() == 1) {
            return names.iterator().next();
        }
        StringBuilder processorBuilder = new StringBuilder();
        StringBuilder idBuilder = new StringBuilder();
        ProcessorPmu.ArchitectureProfile profile = null;
        for (ProcessorPmu name : names) {
            if (processorBuilder.length() > 0) {
                processorBuilder.append(MULTI_NAME_SEPARATOR);
            }
            if (idBuilder.length() > 0) {
                idBuilder.append(MULTI_PNMC_NAME_SEPARATOR);
            }
            processorBuilder.append(name.getCoreName());
            idBuilder.append(name.getId());
            if (profile == null) {
                profile = name.getProfile();
                continue;
            }
            if (profile == name.getProfile()) continue;
            profile = ProcessorPmu.ArchitectureProfile.UNKNOWN;
        }
        assert (profile != null);
        return new ProcessorPmu((String)NullChecking.neverNull((Object)idBuilder.toString()), (String)NullChecking.neverNull((Object)idBuilder.toString()), (String)NullChecking.neverNull((Object)processorBuilder.toString()), new int[]{-1}, 0, (Map)NullChecking.neverNull(Collections.emptyMap()), profile);
    }

    public BarmanClustersInfo(@NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> pmus, @NonNull Collection<@NonNull IBarmanProcessorInformation> processors) throws BarmanDataError {
        TIntSet midrs;
        int clusterId;
        this.mClusterHumanNames = new TIntObjectHashMap(10, 0.5f, -1);
        this.mClusterPmncNames = new TIntObjectHashMap(10, 0.5f, -1);
        this.mClusterMidrs = new TIntObjectHashMap(10, 0.5f, -1);
        this.mClusterCores = new TIntObjectHashMap(10, 0.5f, -1);
        this.mCpuClusterIds = new TIntIntHashMap(10, 0.5f, -1, -1);
        int maxProcessorId = -1;
        for (IBarmanProcessorInformation processor : processors) {
            int processorId = processor.getProcessorId();
            clusterId = processor.getClusterId();
            maxProcessorId = Math.max(maxProcessorId, processorId);
            if (this.mProcessors.put(processorId, (Object)processor) != null) {
                throw new BarmanDataError();
            }
            midrs = (TIntSet)this.mClusterMidrs.get(clusterId);
            if (midrs == null) {
                midrs = new TIntHashSet(10, 0.5f, -1);
                this.mClusterMidrs.put(clusterId, (Object)midrs);
            }
            midrs.add(processor.getMIDR());
            TIntList cores = (TIntList)this.mClusterCores.get(clusterId);
            if (cores == null) {
                cores = new TIntArrayList(10, -1);
                this.mClusterCores.put(clusterId, (Object)cores);
            }
            cores.add(processorId);
            if (this.mCpuClusterIds.put(processorId, clusterId) == this.mCpuClusterIds.getNoEntryValue()) continue;
            throw new BarmanDataError();
        }
        this.mMaxProcessorId = maxProcessorId;
        TIntSet lastMIDRs = null;
        boolean isBigLittle = false;
        TIntObjectIterator it = this.mClusterMidrs.iterator();
        while (it.hasNext()) {
            it.advance();
            clusterId = it.key();
            midrs = (TIntSet)it.value();
            TreeSet<ProcessorPmu> names = new TreeSet<ProcessorPmu>();
            midrs.forEach(midr -> {
                names.add(BarmanClustersInfo.getProcessorName(pmus, midr));
                return true;
            });
            ProcessorPmu name = BarmanClustersInfo.makeClusterName(names);
            this.mClusterHumanNames.put(clusterId, (Object)name.getCoreName());
            this.mClusterPmncNames.put(clusterId, (Object)name.getId());
            if (lastMIDRs != null) {
                isBigLittle |= !midrs.equals((Object)lastMIDRs);
                continue;
            }
            lastMIDRs = midrs;
        }
        this.makeClusterPmncNamesUnique();
        assert (this.mClusterPmncNames.size() == this.mClusterHumanNames.size());
        assert (this.mClusterHumanNames.size() == this.mClusterCores.size());
        assert (this.mClusterHumanNames.size() == this.mClusterMidrs.size());
        assert (this.mProcessors.size() == this.mCpuClusterIds.size());
        this.mBigLITTLE = isBigLittle;
    }

    public @Nullable Integer findClusterIndex(int core) {
        return this.mCpuClusterIds.containsKey(core) ? Integer.valueOf(this.mCpuClusterIds.get(core)) : null;
    }

    public @Nullable Integer findClusterIndex(@Nullable String clusterName) {
        if (clusterName != null) {
            TIntObjectIterator iterator = this.mClusterPmncNames.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                if (!((String)iterator.value()).equals(clusterName)) continue;
                return iterator.key();
            }
        }
        return null;
    }

    public @NonNull String getClusterHumanName(int clusterId) {
        return (String)NullChecking.neverNull((Object)((String)this.mClusterHumanNames.get(clusterId)));
    }

    public @Nullable Integer getClusterIndex(CounterRecord record) {
        return record.getCluster();
    }

    public @Nullable String getClusterName(int clusterId) {
        return (String)this.mClusterPmncNames.get(clusterId);
    }

    public @NonNull TIntObjectMap<String> getClusterNames() {
        return (TIntObjectMap)NullChecking.neverNull((Object)TCollections.unmodifiableMap(this.mClusterPmncNames));
    }

    public @NonNull String getClusterPmncName(int clusterId) {
        return (String)NullChecking.neverNull((Object)((String)this.mClusterPmncNames.get(clusterId)));
    }

    public int getCoreCount() {
        return this.mMaxProcessorId + 1;
    }

    public @Nullable TIntList getCores(int clusterIndex) {
        return (TIntList)this.mClusterCores.get(clusterIndex);
    }

    public @NonNull TIntIntMap getCpuClusterIds() {
        return (TIntIntMap)NullChecking.neverNull((Object)TCollections.unmodifiableMap((TIntIntMap)this.mCpuClusterIds));
    }

    public int getNumberOfClusters() {
        return this.mClusterPmncNames.size();
    }

    public @NonNull Collection<@NonNull IBarmanProcessorInformation> getProcessors() {
        return (Collection)NullChecking.neverNull((Object)this.mProcessors.valueCollection());
    }

    public boolean hasClusters() {
        return this.mBigLITTLE;
    }

    public boolean isGatorClusterInformationMissing() {
        return false;
    }

    public void updateCounterRecordsWithClusterInformation(boolean forceClusters, @NonNull List<@NonNull CounterRecord> counterRecordList) {
    }

    public void writeXML(@NonNull File outputPath) {
        GatorClusters.writeXml((File)outputPath, this.mClusterPmncNames, (TIntIntMap)this.mCpuClusterIds);
    }

    private void makeClusterPmncNamesUnique() {
        String name;
        HashSet<String> seenNames = new HashSet<String>();
        TObjectIntHashMap duplicateNames = new TObjectIntHashMap(10, 0.5f, -1);
        TIntObjectIterator iterator = this.mClusterPmncNames.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            name = (String)iterator.value();
            if (seenNames.add(name)) continue;
            duplicateNames.put((Object)name, 0);
        }
        iterator = this.mClusterPmncNames.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            name = (String)iterator.value();
            int counter = duplicateNames.get((Object)name);
            if (counter == duplicateNames.getNoEntryValue()) continue;
            iterator.setValue((Object)(name + "_" + counter));
            duplicateNames.put((Object)name, counter + 1);
        }
    }
}

