/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.libs;

import com.arm.io.Files;
import com.arm.io.JVMTempFolder;
import com.arm.util.Tuple;
import com.arm.util.libs.AbstractURLResolver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarURLResolver
extends AbstractURLResolver {
    @Override
    public String getPhysicalPath(URL url) throws IOException {
        return (String)this.parse((URL)url).tb;
    }

    @Override
    public String getSupportedProtocol() {
        return "jar";
    }

    @Override
    public File resolve(URL url) throws IOException {
        return this.resolve(url, null);
    }

    @Override
    public File resolve(URL url, File targetDir) throws IOException {
        Tuple<String, String> parsed = this.parse(url);
        return JarURLResolver.extract(new File((String)parsed.ta), (String)parsed.tb, targetDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static File extract(File jarFile, String entry, File targetDir) throws IOException {
        if (targetDir == null) {
            targetDir = JVMTempFolder.getJVMTempFolder();
        } else {
            Files.mkdirs(targetDir);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileInputStream fis = new FileInputStream(jarFile);
            try {
                block37: {
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    try {
                        block36: {
                            ZipFile zipFile = new ZipFile(jarFile);
                            try {
                                try (ZipInputStream zis = new ZipInputStream(bis);){
                                    ZipEntry ze = zis.getNextEntry();
                                    while (ze != null) {
                                        block38: {
                                            File extractedFile;
                                            block40: {
                                                block39: {
                                                    String entryName = ze.getName();
                                                    if (!entryName.startsWith(entry)) break block38;
                                                    extractedFile = new File(targetDir, entryName);
                                                    if (!ze.isDirectory()) break block39;
                                                    Files.mkdirs(extractedFile);
                                                    break block38;
                                                }
                                                if (!extractedFile.exists()) break block40;
                                                if (extractedFile.lastModified() == ze.getTime()) break block38;
                                                Files.delete(extractedFile);
                                            }
                                            Files.mkdirs(extractedFile.getParentFile());
                                            Files.createFile(extractedFile);
                                            Throwable throwable2 = null;
                                            Object var13_19 = null;
                                            try (InputStream is = zipFile.getInputStream(ze);){
                                                Files.copy(is, extractedFile);
                                            }
                                            catch (Throwable throwable3) {
                                                if (throwable2 == null) {
                                                    throwable2 = throwable3;
                                                    throw throwable2;
                                                }
                                                if (throwable2 == throwable3) throw throwable2;
                                                throwable2.addSuppressed(throwable3);
                                                throw throwable2;
                                            }
                                            if (ze.getTime() != -1L) {
                                                extractedFile.setLastModified(ze.getTime());
                                            }
                                        }
                                        ze = zis.getNextEntry();
                                    }
                                }
                                if (zipFile == null) break block36;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (zipFile == null) throw throwable;
                                zipFile.close();
                                throw throwable;
                            }
                            zipFile.close();
                        }
                        if (bis == null) break block37;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (bis == null) throw throwable;
                        bis.close();
                        throw throwable;
                    }
                    bis.close();
                }
                if (fis == null) return new File(targetDir, entry);
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return new File(targetDir, entry);
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
                throw throwable;
            }
            if (throwable == throwable7) throw throwable;
            throwable.addSuppressed(throwable7);
            throw throwable;
        }
    }

    private Tuple<String, String> parse(URL url) throws IOException {
        int lastCharIndex;
        String path;
        this.checkSupportedProtocol(url);
        URL fileURL = new URL(url.getPath());
        try {
            path = fileURL.toURI().getSchemeSpecificPart();
        }
        catch (URISyntaxException e) {
            path = fileURL.getPath();
        }
        int mark = path.indexOf(33);
        String jar = path.substring(0, mark);
        String entry = path.substring(mark + 2);
        if (!entry.isEmpty() && entry.charAt(lastCharIndex = entry.length() - 1) == '/') {
            entry = entry.substring(0, lastCharIndex);
        }
        return new Tuple<String, String>(jar, entry);
    }
}

