/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;

public class Files {
    public static void copy(File src, File target) throws IOException {
        Files.copy(src, target, false);
    }

    public static void copy(File src, File target, boolean preservePermissions) throws IOException {
        Files.copy(src, target, preservePermissions, false);
    }

    public static void copy(File src, File target, boolean preservePermissions, boolean overwrite) throws IOException {
        if (src.isDirectory() && target.exists() && target.isDirectory()) {
            target = new File(target, src.getName());
        }
        Files.copyImpl(src, target, preservePermissions, overwrite);
    }

    public static void copy(InputStream src, File target) throws IOException {
        Files.copy(src, target, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(InputStream src, File target, boolean lock) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedInputStream in = new BufferedInputStream(src);
            try {
                try (FileOutputStream fos = new FileOutputStream(target);){
                    FileLock lockFile;
                    FileLock fileLock = lockFile = lock ? fos.getChannel().tryLock() : null;
                    if (lockFile == null && lock) {
                        throw new IOException("Unable to acquire lock");
                    }
                    try {
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (BufferedOutputStream out = new BufferedOutputStream(fos);){
                            byte[] buffer = new byte[0x100000];
                            int n = 1;
                            while (n > 0) {
                                n = in.read(buffer);
                                if (n <= 0) continue;
                                out.write(buffer, 0, n);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (lockFile != null) {
                            lockFile.close();
                        }
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static void createFile(File file) throws IOException {
        if (!file.createNewFile() && !file.exists()) {
            throw new IOException("could not create file " + String.valueOf(file));
        }
    }

    public static void createFile(File dir, File file) throws IOException {
        Files.mkdirs(dir);
        Files.createFile(file);
    }

    public static File createTempDir(String prefix) throws IOException {
        final File tempFile = File.createTempFile(prefix, "");
        if (!tempFile.delete() || tempFile.exists()) {
            throw new IOException("Unable to delete file: " + tempFile.getAbsolutePath());
        }
        if (!tempFile.mkdir() || !tempFile.exists()) {
            throw new IOException("Unable to create temp directory: " + tempFile.getAbsolutePath());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (tempFile.exists()) {
                    try {
                        Files.delete(tempFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        return tempFile;
    }

    public static List<File> delete(File file) throws IOException {
        ArrayList<File> survivors = new ArrayList<File>();
        Files.delete(file, survivors);
        return survivors;
    }

    public static File[] listFiles(File dir) {
        if (dir == null || dir.listFiles() == null) {
            return new File[0];
        }
        return dir.listFiles();
    }

    public static void mkdirs(File dir) throws IOException {
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            throw new IOException("could not create folder " + String.valueOf(dir));
        }
    }

    private static void copyImpl(File src, File target, boolean preservePermissions, boolean overwrite) throws IOException {
        if (!overwrite && target.exists()) {
            throw new IOException("target '" + target.getPath() + "' already exists");
        }
        if (src.isDirectory()) {
            Files.mkdirs(target);
            File[] fileArray = Files.listFiles(src);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                Files.copyImpl(child, new File(target, child.getName()), preservePermissions, overwrite);
                ++n2;
            }
        } else {
            Files.mkdirs(target.getParentFile());
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileInputStream is = new FileInputStream(src);){
                Files.copy(is, target);
                if (preservePermissions) {
                    target.setExecutable(src.canExecute());
                    target.setReadable(src.canRead());
                    target.setWritable(src.canWrite());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static void delete(File file, List<File> survivors) throws IOException {
        if (file != null && file.exists()) {
            File[] child;
            if (file.isDirectory() && (child = file.listFiles()) != null && child.length > 0) {
                int i = 0;
                while (i < child.length) {
                    Files.delete(child[i], survivors);
                    ++i;
                }
            }
            if (!file.delete() && file.exists()) {
                survivors.add(file);
            }
        }
    }
}

