/*
 * Decompiled with CFR 0.152.
 */
package com.arm.ini;

import com.arm.util.Platform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;

public class IniFileWriter {
    private final StringBuilder builder = new StringBuilder();

    public void appendComment(String comment) {
        this.builder.append(';');
        this.builder.append(' ');
        this.builder.append(comment);
        this.builder.append(Platform.LS);
    }

    public void appendProperties(Map<String, String> properties) {
        properties.forEach(this::appendProperty);
    }

    public void appendProperty(String key, String value) {
        this.builder.append(key);
        this.builder.append('=');
        this.builder.append(value);
        this.builder.append(Platform.LS);
    }

    public void appendSection(String name) {
        this.appendSection(name, this.builder.length() > 0);
    }

    public void appendSection(String name, String comment) {
        this.appendSection(name, comment, this.builder.length() > 0);
    }

    public void write(File file) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            this.write(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(OutputStream out) {
        PrintWriter w = new PrintWriter(out);
        w.print(this.builder.toString());
        w.flush();
    }

    private void appendSection(String name, boolean initialNewline) {
        if (initialNewline) {
            this.builder.append(Platform.LS);
        }
        this.builder.append('[');
        this.builder.append(name);
        this.builder.append(']');
        this.builder.append(Platform.LS);
    }

    private void appendSection(String name, String comment, boolean initialNewline) {
        if (initialNewline) {
            this.builder.append(Platform.LS);
        }
        this.appendComment(comment);
        this.appendSection(name, false);
    }
}

