/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.text;

import com.arm.utils.NullChecking;
import java.text.StringCharacterIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BasicStringUtils {
    private static final @NonNull Pattern WORDS = Pattern.compile("[\\p{IsAlphabetic}\\p{IsDigit}]+");

    public static @NonNull String capitalize(@NonNull String text) {
        if (text.length() > 1) {
            return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
        }
        return NullChecking.neverNull(text.toUpperCase());
    }

    public static @NonNull String capitalizeFirst(@NonNull String text) {
        if (text.length() > 1) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return NullChecking.neverNull(text.toUpperCase());
    }

    public static @NonNull String concatenate(@NonNull Iterable<@NonNull String> strings, @NonNull String seperator) {
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            if (builder.length() > 0) {
                builder.append(seperator);
            }
            builder.append(string);
        }
        return NullChecking.neverNull(builder.toString());
    }

    public static @Nullable String concatenateNullable(@NonNull Iterable<@Nullable String> strings, @NonNull String seperator) {
        StringBuilder builder = null;
        for (String string : strings) {
            if (string == null) continue;
            if (builder != null) {
                builder.append(seperator);
            } else {
                builder = new StringBuilder();
            }
            builder.append(string);
        }
        if (builder != null) {
            return builder.toString();
        }
        return null;
    }

    public static @NonNull String escapeString(@NonNull String string) {
        StringBuilder result = new StringBuilder(string.length());
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\"') {
                result.append("\\\"");
            } else if (c == '\\') {
                result.append("\\\\");
            } else if (c < ' ') {
                result.append(' ');
            } else if (c < '\u0080') {
                result.append(c);
            } else {
                result.append(' ');
            }
            ++i;
        }
        return NullChecking.neverNull(result.toString());
    }

    public static @NonNull String longestCommonPrefix(@NonNull String a, @NonNull String b) {
        StringCharacterIterator aIter = new StringCharacterIterator(a);
        StringCharacterIterator bIter = new StringCharacterIterator(b);
        char aChar = aIter.current();
        char bChar = bIter.current();
        while (aChar == bChar && aChar != '\uffff') {
            aChar = aIter.next();
            bChar = bIter.next();
        }
        return a.substring(0, aIter.getIndex());
    }

    public static @NonNull String longestCommonPrefix(@NonNull String a, @NonNull String b, @NonNull String separators) {
        StringCharacterIterator aIter = new StringCharacterIterator(a);
        StringCharacterIterator bIter = new StringCharacterIterator(b);
        char aChar = aIter.current();
        char bChar = bIter.current();
        int index = 0;
        while (aChar != '\uffff' || bChar != '\uffff') {
            if (aChar == '\uffff' || bChar == '\uffff') {
                char nextChar;
                char c = nextChar = aChar != '\uffff' ? aChar : bChar;
                if (separators.indexOf(nextChar) == -1) break;
                index = aIter.getIndex();
                break;
            }
            if (aChar == bChar) {
                if (separators.indexOf(aChar) != -1) {
                    index = aIter.getIndex();
                }
            } else {
                if (separators.indexOf(aChar) == -1 || separators.indexOf(bChar) == -1) break;
                index = aIter.getIndex();
                break;
            }
            aChar = aIter.next();
            bChar = bIter.next();
        }
        return a.substring(0, index);
    }

    public static final @NonNull String makeIdentifier(@NonNull String string) {
        if (string.isEmpty()) {
            return "_";
        }
        String result = string.replaceAll("[^0-9A-Za-z_]", "_");
        return (Character.isDigit(result.charAt(0)) ? "_" : "") + result;
    }

    public static @NonNull String @NonNull [] splitHandlingEmpty(@NonNull CharSequence input, @NonNull Pattern pattern) {
        if (input.length() == 0) {
            return new String[0];
        }
        return pattern.split(input);
    }

    public static @NonNull String titleCase(@NonNull String sentence) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = WORDS.matcher(sentence);
        int lastFrom = 0;
        while (matcher.find()) {
            int wordStart = matcher.start();
            String word = NullChecking.neverNull(matcher.group());
            result.append(sentence.substring(lastFrom, wordStart));
            if (BasicStringUtils.isLowerCase(word)) {
                result.append(BasicStringUtils.capitalizeFirst(word));
            } else {
                result.append(word);
            }
            lastFrom = matcher.end();
        }
        result.append(sentence.substring(lastFrom));
        return result.toString();
    }

    private static boolean isLowerCase(@NonNull String word) {
        return word.chars().allMatch(Character::isLowerCase);
    }
}

