/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.text;

import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class BasicNumberUtils {
    public static final String HEX_PREFIX = "0x";
    protected static final String HEX_PREFIX2 = "0X";
    private static final int FORMATTER_CACHE_SIZE = 10;
    private static final @NonNull ThreadLocal<@NonNull LinkedHashMap<@NonNull Integer, @NonNull NumberFormat>> FORMATERS = ThreadLocal.withInitial(() -> new CacheMap(10, 1.0f, true));

    public static long decodeUnsignedLong(@NonNull String string) {
        if (string.startsWith(HEX_PREFIX) || string.startsWith(HEX_PREFIX2)) {
            return Long.parseUnsignedLong(string.substring(2), 16);
        }
        if (string.startsWith("0b") || string.startsWith("0B")) {
            return Long.parseUnsignedLong(string.substring(2), 2);
        }
        if (string.startsWith("#")) {
            return Long.parseUnsignedLong(string.substring(1), 16);
        }
        if (string.startsWith("0")) {
            return Long.parseUnsignedLong(string, 8);
        }
        return Long.parseUnsignedLong(string, 10);
    }

    public static int decodeUnsignedInt(@NonNull String string) {
        if (string.startsWith(HEX_PREFIX) || string.startsWith(HEX_PREFIX2)) {
            return Integer.parseUnsignedInt(string.substring(2), 16);
        }
        if (string.startsWith("0b") || string.startsWith("0B")) {
            return Integer.parseUnsignedInt(string.substring(2), 2);
        }
        if (string.startsWith("#")) {
            return Integer.parseUnsignedInt(string.substring(1), 16);
        }
        if (string.startsWith("0")) {
            return Integer.parseUnsignedInt(string, 8);
        }
        return Integer.parseUnsignedInt(string, 10);
    }

    public static boolean getBoolean(String buffer) {
        return "true".equalsIgnoreCase(buffer = BasicNumberUtils.strip(buffer)) || "yes".equalsIgnoreCase(buffer) || "on".equalsIgnoreCase(buffer) || "1".equals(buffer);
    }

    public static @NonNull NumberFormat getFormatter(int minimumFractionalDigits, int maximumFractionalDigits) {
        Integer key = minimumFractionalDigits + (maximumFractionalDigits << 16);
        LinkedHashMap<@NonNull Integer, @NonNull NumberFormat> map = FORMATERS.get();
        NumberFormat existing = map.get(key);
        if (existing != null) {
            return existing;
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumFractionDigits(minimumFractionalDigits);
        format.setMaximumFractionDigits(maximumFractionalDigits);
        map.put(key, format);
        return format;
    }

    public static double getNonLocalizedDouble(String buffer, double defValue) {
        try {
            return Double.parseDouble(BasicNumberUtils.strip(buffer));
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static int getNonLocalizedHexInteger(String buffer, int defValue) {
        try {
            buffer = BasicNumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                buffer = buffer.substring(HEX_PREFIX.length());
            } else if (buffer.startsWith(HEX_PREFIX2)) {
                buffer = buffer.substring(HEX_PREFIX2.length());
            }
            if (buffer.length() == 8) {
                int value = Character.digit(buffer.charAt(0), 16);
                return value << 28 | Integer.parseInt(buffer.substring(1), 16);
            }
            return Integer.parseInt(buffer, 16);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static long getNonLocalizedHexLong(String buffer, long defValue) {
        try {
            buffer = BasicNumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                buffer = buffer.substring(HEX_PREFIX.length());
            } else if (buffer.startsWith(HEX_PREFIX2)) {
                buffer = buffer.substring(HEX_PREFIX2.length());
            }
            if (buffer.length() == 16) {
                long value = Character.digit(buffer.charAt(0), 16);
                return value << 60 | Long.parseLong(buffer.substring(1), 16);
            }
            return Long.parseLong(buffer, 16);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static int getNonLocalizedInteger(String buffer, int defValue) {
        try {
            buffer = BasicNumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return BasicNumberUtils.getNonLocalizedHexInteger(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return BasicNumberUtils.getNonLocalizedHexInteger(buffer, defValue);
            }
            return Integer.parseInt(buffer);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static long getNonLocalizedLong(String buffer, long defValue) {
        try {
            buffer = BasicNumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return BasicNumberUtils.getNonLocalizedHexLong(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return BasicNumberUtils.getNonLocalizedHexLong(buffer, defValue);
            }
            return Long.parseLong(buffer);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    protected static String strip(String buffer) {
        if (buffer == null) {
            return "";
        }
        return (buffer = buffer.trim()).startsWith("+") ? buffer.substring(1) : buffer;
    }

    private static final class CacheMap
    extends LinkedHashMap<Integer, NumberFormat> {
        private CacheMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<@NonNull Integer, @NonNull NumberFormat> eldest) {
            return this.size() >= 10;
        }
    }
}

