/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.io;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public class GrowableTargetByteBuffer {
    private final boolean bits64;
    private @NonNull ByteBuffer data;

    public GrowableTargetByteBuffer() {
        this(false, false, 0);
    }

    public GrowableTargetByteBuffer(boolean bigEndian, boolean bits64) {
        this(bigEndian, bits64, 0);
    }

    public GrowableTargetByteBuffer(boolean bigEndian, boolean bits64, int initialCapacity) {
        this.bits64 = bits64;
        this.data = ByteBuffer.allocate(initialCapacity).order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    public @NonNull GrowableTargetByteBuffer alignTo(int alignment) {
        if (alignment < 1) {
            throw new IllegalArgumentException("invalid alignment");
        }
        int n = this.position() % alignment;
        if (n > 0) {
            this.skip(alignment - n);
        }
        return this;
    }

    public byte @NonNull [] getBytes() {
        return Arrays.copyOf(this.data.array(), this.data.position());
    }

    public byte @NonNull [] getBytes(int begin, int end) {
        if (begin < this.data.capacity()) {
            return Arrays.copyOfRange(this.data.array(), begin, end);
        }
        return new byte[end - begin];
    }

    public int position() {
        return this.data.position();
    }

    public @NonNull GrowableTargetByteBuffer position(int newPosition) {
        this.prepareToWrite(newPosition, 0);
        this.data.position(newPosition);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put(byte @NonNull [] bytes) {
        this.prepareToWrite(bytes.length);
        this.data.put(bytes);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put16(int pos, short value) {
        this.prepareToWrite(pos, 2);
        this.data.putShort(value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put16(short value) {
        this.prepareToWrite(2);
        this.data.putShort(value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put32(int value) {
        this.prepareToWrite(4);
        this.data.putInt(value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put32(int pos, int value) {
        this.prepareToWrite(pos, 4);
        this.data.putInt(pos, value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put64(int pos, long value) {
        this.prepareToWrite(pos, 8);
        this.data.putLong(pos, value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put64(long value) {
        this.prepareToWrite(8);
        this.data.putLong(value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put8(byte value) {
        this.prepareToWrite(1);
        this.data.put(value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer put8(int pos, byte value) {
        this.prepareToWrite(pos, 1);
        this.data.put(pos, value);
        return this;
    }

    public @NonNull GrowableTargetByteBuffer putPointer(int pos, long value) {
        return this.bits64 ? this.put64(pos, value) : this.put32(pos, (int)value);
    }

    public @NonNull GrowableTargetByteBuffer putPointer(long value) {
        return this.bits64 ? this.put64(value) : this.put32((int)value);
    }

    public @NonNull GrowableTargetByteBuffer skip(int bytes) {
        long newPos = (long)this.position() + (long)bytes;
        if (newPos < 0L || newPos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid final position");
        }
        this.position((int)newPos);
        return this;
    }

    private void prepareToWrite(int size) {
        this.prepareToWrite(this.data.position(), size);
    }

    private void prepareToWrite(int pos, int size) {
        byte[] newArray;
        long end = (long)pos + (long)size;
        if (end <= (long)this.data.capacity()) {
            return;
        }
        if (end < 0x3FFFFFFFL) {
            newArray = Arrays.copyOf(this.data.array(), (int)end * 2);
        } else if (end <= Integer.MAX_VALUE) {
            newArray = Arrays.copyOf(this.data.array(), Integer.MAX_VALUE);
        } else {
            throw new BufferOverflowException();
        }
        ByteOrder bo = this.data.order();
        int position = this.data.position();
        this.data = ByteBuffer.wrap(newArray).order(bo);
        this.data.position(position);
    }
}

