/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class ByteBufferUtils {
    public static void advance(ByteBuffer buffer, int numBytes) {
        buffer.position(buffer.position() + numBytes);
    }

    public static int read1byteUnsigned(@NonNull ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    public static int read2bytesUnsigned(ByteBuffer buffer) {
        return buffer.getShort() & 0xFFFF;
    }

    public static long read4bytesUnsigned(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static long read8bytesUnsigned(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static int readFully(@NonNull InputStream stream, @NonNull ByteBuffer buffer) throws IOException {
        int total = 0;
        while (buffer.hasRemaining()) {
            int n = stream.read(buffer.array(), buffer.position(), buffer.remaining());
            if (n < 0) {
                return total == 0 ? -1 : total;
            }
            buffer.position(buffer.position() + n);
            total += n;
        }
        return total;
    }

    public static byte @NonNull [] readNbytes(ByteBuffer buffer, int n) {
        byte @NonNull [] bn = new byte[n];
        buffer.get(bn);
        return bn;
    }
}

