/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.datainput;

import com.arm.utils.function.IThrowingFunction;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class StreamUtils {
    public static void readFully(@NonNull InputStream inputStream, byte[] data) throws IOException {
        StreamUtils.readFully(inputStream, data, 0, data.length);
    }

    public static void readFully(@NonNull InputStream inputStream, byte[] data, int offset, int length) throws IOException {
        int read;
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int pos = 0; pos < length; pos += read) {
            read = inputStream.read(data, offset + pos, length - pos);
            if (read >= 0) {
                continue;
            }
            throw new EOFException();
        }
    }

    public static <R, E extends Throwable> R tryWithNullable(@Nullable InputStream stream, @NonNull IThrowingFunction<@NonNull InputStream, R, E> mapper, R nullDefault) throws IOException, E {
        if (stream == null) {
            return nullDefault;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream s = stream;){
            return mapper.apply(s);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

