/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.datainput;

import com.arm.utils.datainput.StreamUtils;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public class LittleEndianDataInputStream
extends InputStream
implements DataInput {
    protected final @NonNull InputStream inputStream;

    public LittleEndianDataInputStream(@NonNull InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int result = this.inputStream.read();
        if (result >= 0) {
            return (byte)result;
        }
        throw new EOFException();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    @Override
    public void readFully(byte[] data, int offset, int length) throws IOException {
        StreamUtils.readFully(this.inputStream, data, offset, length);
    }

    @Override
    public int readInt() throws IOException {
        int b1 = this.inputStream.read();
        int b2 = this.inputStream.read();
        int b3 = this.inputStream.read();
        int b4 = this.inputStream.read();
        if (b1 >= 0 && b2 >= 0 && b3 >= 0 && b4 >= 0) {
            return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
        }
        throw new EOFException();
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder result;
        block3: {
            result = new StringBuilder();
            try {
                byte b;
                char c;
                while ((c = (char)((b = this.readByte()) & 0xFF)) != '\n') {
                    if (c == '\r') continue;
                    result.append(c);
                }
            }
            catch (EOFException e) {
                if (result.length() != 0) break block3;
                return null;
            }
        }
        return result.toString();
    }

    @Override
    public long readLong() throws IOException {
        long b1 = this.inputStream.read();
        long b2 = this.inputStream.read();
        long b3 = this.inputStream.read();
        long b4 = this.inputStream.read();
        long b5 = this.inputStream.read();
        long b6 = this.inputStream.read();
        long b7 = this.inputStream.read();
        long b8 = this.inputStream.read();
        if (b1 >= 0L && b2 >= 0L && b3 >= 0L && b4 >= 0L && b5 >= 0L && b6 >= 0L && b7 >= 0L && b8 >= 0L) {
            return b1 & 0xFFL | (b2 & 0xFFL) << 8 | (b3 & 0xFFL) << 16 | (b4 & 0xFFL) << 24 | (b5 & 0xFFL) << 32 | (b6 & 0xFFL) << 40 | (b7 & 0xFFL) << 48 | (b8 & 0xFFL) << 56;
        }
        throw new EOFException();
    }

    @Override
    public short readShort() throws IOException {
        int b1 = this.inputStream.read();
        int b2 = this.inputStream.read();
        if (b1 >= 0 && b2 >= 0) {
            return (short)(b1 & 0xFF | (b2 & 0xFF) << 8);
        }
        throw new EOFException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        int length = this.readUnsignedShort();
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.inputStream.skip(n);
    }
}

