/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.NullChecking;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class OptionalUtils {
    public static <T> boolean equalsValue(@NonNull Optional<? extends T> optional, @NonNull T value) {
        if (optional.isPresent()) {
            return optional.get().equals(value);
        }
        return false;
    }

    public static @NonNull OptionalInt filter(@NonNull OptionalInt optional, @NonNull IntPredicate predicate) {
        if (!optional.isPresent()) {
            return optional;
        }
        return predicate.test(optional.getAsInt()) ? optional : OptionalInt.empty();
    }

    public static @NonNull OptionalLong filter(@NonNull OptionalLong optional, @NonNull LongPredicate predicate) {
        if (!optional.isPresent()) {
            return optional;
        }
        return predicate.test(optional.getAsLong()) ? optional : OptionalLong.empty();
    }

    public static <U> @NonNull OptionalInt flatMapToInt(@NonNull Optional<U> o, @NonNull Function<U, OptionalInt> mapper) {
        if (!o.isPresent()) {
            return OptionalInt.empty();
        }
        return NullChecking.neverNull(mapper.apply(o.get()));
    }

    public static <U> @NonNull OptionalLong flatMapToLong(@NonNull Optional<U> o, @NonNull Function<U, OptionalLong> mapper) {
        if (!o.isPresent()) {
            return OptionalLong.empty();
        }
        return NullChecking.neverNull(mapper.apply(o.get()));
    }

    public static <U> @NonNull Optional<U> flatMapToObj(@NonNull OptionalInt oint, @NonNull IntFunction<Optional<U>> mapper) {
        if (!oint.isPresent()) {
            return Optional.empty();
        }
        return NullChecking.neverNull(mapper.apply(oint.getAsInt()));
    }

    public static <T> @NonNull Optional<T> flatOrElse(@NonNull Optional<? extends T> a, @NonNull Optional<? extends T> b) {
        if (a.isPresent()) {
            return OptionalUtils.superOf(a);
        }
        return OptionalUtils.superOf(b);
    }

    public static @NonNull OptionalInt flatOrElse(@NonNull OptionalInt a, @NonNull OptionalInt b) {
        if (a.isPresent()) {
            return a;
        }
        return b;
    }

    public static <T> void ifPresentOrElse(@NonNull Optional<T> optional, @NonNull Consumer<? super @NonNull T> ifPresent, @NonNull Runnable ifEmpty) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.get());
        } else {
            ifEmpty.run();
        }
    }

    public static void ifPresentOrElse(@NonNull OptionalInt optional, @NonNull IntConsumer ifPresent, @NonNull Runnable ifEmpty) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.getAsInt());
        } else {
            ifEmpty.run();
        }
    }

    public static void ifPresentOrElse(@NonNull OptionalLong optional, @NonNull LongConsumer ifPresent, @NonNull Runnable ifEmpty) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.getAsLong());
        } else {
            ifEmpty.run();
        }
    }

    public static @NonNull OptionalInt map(@NonNull OptionalInt oint, @NonNull IntUnaryOperator mapper) {
        if (!oint.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(mapper.applyAsInt(oint.getAsInt()));
    }

    public static <U> @NonNull OptionalInt mapToInt(@NonNull Optional<U> o, @NonNull ToIntFunction<? super @NonNull U> mapper) {
        if (!o.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(mapper.applyAsInt(o.get()));
    }

    public static <U> @NonNull OptionalLong mapToLong(@NonNull Optional<U> o, @NonNull ToLongFunction<? super U> mapper) {
        if (!o.isPresent()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(mapper.applyAsLong(o.get()));
    }

    public static <U> @NonNull Optional<U> mapToObj(@NonNull OptionalInt oint, @NonNull IntFunction<? extends U> mapper) {
        if (!oint.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(oint.getAsInt()));
    }

    public static <U> @NonNull Optional<U> mapToObj(@NonNull OptionalLong olong, @NonNull LongFunction<? extends U> mapper) {
        if (!olong.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(olong.getAsLong()));
    }

    public static @NonNull OptionalInt ofIfNonNegative(int value) {
        if (value > 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    public static @NonNull OptionalInt ofIfNot(int value, int notPresentValue) {
        if (value == notPresentValue) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    public static @NonNull OptionalInt ofInteger(@Nullable Integer i) {
        return i != null ? OptionalInt.of(i) : OptionalInt.empty();
    }

    public static <T, U extends T> @NonNull Optional<T> or(@NonNull Optional<? extends T> a, @NonNull Supplier<? extends @NonNull Optional<U>> b) {
        if (a.isPresent()) {
            return OptionalUtils.superOf(a);
        }
        return OptionalUtils.superOf(b.get());
    }

    public static <T> T orElse(@NonNull Optional<? extends T> optional, T other) {
        if (optional.isPresent()) {
            return optional.get();
        }
        return other;
    }

    public static <T> T orElseGet(@NonNull Optional<? extends T> optional, Supplier<? extends T> other) {
        if (optional.isPresent()) {
            return optional.get();
        }
        return other.get();
    }

    public static <T, U extends T> @NonNull Optional<T> superOf(@NonNull Optional<U> optional) {
        if (optional.isPresent()) {
            return Optional.of(optional.get());
        }
        return Optional.empty();
    }
}

