/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingSupplier;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MapUtils {
    public static <K, V, E extends Throwable> V computeIfAbsentThrows(@NonNull Map<K, V> map, K key, @NonNull IThrowingFunction<? super K, ? extends V, E> mappingFunction) throws E {
        if (map.containsKey(key)) {
            V result = map.get(key);
            return result;
        }
        V value = mappingFunction.apply(key);
        map.put(key, value);
        return value;
    }

    public static <K, V> @Nullable V computeIfAbsentWithNullableValue(@NonNull Map<K, @Nullable V> map, K key, @NonNull Supplier<? extends V> creator) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        V value = creator.get();
        map.put(key, value);
        return value;
    }

    public static <V> V getOrCreate(@NonNull TIntObjectMap<V> map, int key, @NonNull Supplier<? extends V> creator) {
        if (map.containsKey(key)) {
            Object result = map.get(key);
            return (V)result;
        }
        V value = creator.get();
        map.put(key, value);
        return value;
    }

    public static <V> V getOrCreate(@NonNull TLongObjectMap<V> map, long key, @NonNull Supplier<? extends V> creator) {
        if (map.containsKey(key)) {
            Object result = map.get(key);
            return (V)result;
        }
        V value = creator.get();
        map.put(key, value);
        return value;
    }

    public static <K, V, E extends Throwable> V getOrCreateThrows(@NonNull Map<K, V> map, K key, @NonNull IThrowingSupplier<? extends V, E> creator) throws E {
        if (map.containsKey(key)) {
            V result = map.get(key);
            return result;
        }
        V value = creator.get();
        map.put(key, value);
        return value;
    }

    public static @Nullable Integer getOrNull(@NonNull TLongIntMap map, long key) {
        if (map.containsKey(key)) {
            int result = map.get(key);
            return result;
        }
        return null;
    }

    public static <T> @NonNull Iterator<@NonNull ObjIntPair<T>> iterator(@NonNull TIntObjectMap<T> map) {
        final TIntObjectIterator iterator = map.iterator();
        return new Iterator<ObjIntPair<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public ObjIntPair<T> next() {
                iterator.advance();
                return new ObjIntPair<Object>(iterator.value(), iterator.key());
            }
        };
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue) {
        return new TIntIntHashMap(10, 0.5f, 0, noEntryValue);
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue);
        map.put(k1, v1);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + k2);
        }
        map.put(k2, v2);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + k3);
        }
        map.put(k3, v3);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3, int k4, int v4) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + k4);
        }
        map.put(k4, v4);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3, int k4, int v4, int k5, int v5) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + k5);
        }
        map.put(k5, v5);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3, int k4, int v4, int k5, int v5, int k6, int v6) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + k6);
        }
        map.put(k6, v6);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3, int k4, int v4, int k5, int v5, int k6, int v6, int k7, int v7) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + k7);
        }
        map.put(k7, v7);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3, int k4, int v4, int k5, int v5, int k6, int v6, int k7, int v7, int k8, int v8) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + k8);
        }
        map.put(k8, v8);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3, int k4, int v4, int k5, int v5, int k6, int v6, int k7, int v7, int k8, int v8, int k9, int v9) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + k9);
        }
        map.put(k9, v9);
        return map;
    }

    public static @NonNull TIntIntMap ofIntInt(int noEntryValue, int k1, int v1, int k2, int v2, int k3, int v3, int k4, int v4, int k5, int v5, int k6, int v6, int k7, int v7, int k8, int v8, int k9, int v9, int k10, int v10) {
        TIntIntMap map = MapUtils.ofIntInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + k10);
        }
        map.put(k10, v10);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue) {
        return new TIntLongHashMap(10, 0.5f, 0, noEntryValue);
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue);
        map.put(k1, v1);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + k2);
        }
        map.put(k2, v2);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + k3);
        }
        map.put(k3, v3);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3, int k4, long v4) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + k4);
        }
        map.put(k4, v4);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3, int k4, long v4, int k5, long v5) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + k5);
        }
        map.put(k5, v5);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3, int k4, long v4, int k5, long v5, int k6, long v6) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + k6);
        }
        map.put(k6, v6);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3, int k4, long v4, int k5, long v5, int k6, long v6, int k7, long v7) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + k7);
        }
        map.put(k7, v7);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3, int k4, long v4, int k5, long v5, int k6, long v6, int k7, long v7, int k8, long v8) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + k8);
        }
        map.put(k8, v8);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3, int k4, long v4, int k5, long v5, int k6, long v6, int k7, long v7, int k8, long v8, int k9, long v9) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + k9);
        }
        map.put(k9, v9);
        return map;
    }

    public static @NonNull TIntLongMap ofIntLong(long noEntryValue, int k1, long v1, int k2, long v2, int k3, long v3, int k4, long v4, int k5, long v5, int k6, long v6, int k7, long v7, int k8, long v8, int k9, long v9, int k10, long v10) {
        TIntLongMap map = MapUtils.ofIntLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + k10);
        }
        map.put(k10, v10);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject() {
        return new TIntObjectHashMap();
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1) {
        TIntObjectMap<T> map = MapUtils.ofIntObject();
        map.put(k1, v1);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + k2);
        }
        map.put(k2, v2);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + k3);
        }
        map.put(k3, v3);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3, int k4, T v4) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + k4);
        }
        map.put(k4, v4);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3, int k4, T v4, int k5, T v5) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + k5);
        }
        map.put(k5, v5);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3, int k4, T v4, int k5, T v5, int k6, T v6) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + k6);
        }
        map.put(k6, v6);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3, int k4, T v4, int k5, T v5, int k6, T v6, int k7, T v7) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + k7);
        }
        map.put(k7, v7);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3, int k4, T v4, int k5, T v5, int k6, T v6, int k7, T v7, int k8, T v8) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + k8);
        }
        map.put(k8, v8);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3, int k4, T v4, int k5, T v5, int k6, T v6, int k7, T v7, int k8, T v8, int k9, T v9) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + k9);
        }
        map.put(k9, v9);
        return map;
    }

    public static <T> @NonNull TIntObjectMap<T> ofIntObject(int k1, T v1, int k2, T v2, int k3, T v3, int k4, T v4, int k5, T v5, int k6, T v6, int k7, T v7, int k8, T v8, int k9, T v9, int k10, T v10) {
        TIntObjectMap<T> map = MapUtils.ofIntObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + k10);
        }
        map.put(k10, v10);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue) {
        return new TLongIntHashMap(10, 0.5f, 0L, noEntryValue);
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue);
        map.put(k1, v1);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + k2);
        }
        map.put(k2, v2);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + k3);
        }
        map.put(k3, v3);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3, long k4, int v4) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + k4);
        }
        map.put(k4, v4);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3, long k4, int v4, long k5, int v5) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + k5);
        }
        map.put(k5, v5);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3, long k4, int v4, long k5, int v5, long k6, int v6) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + k6);
        }
        map.put(k6, v6);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3, long k4, int v4, long k5, int v5, long k6, int v6, long k7, int v7) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + k7);
        }
        map.put(k7, v7);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3, long k4, int v4, long k5, int v5, long k6, int v6, long k7, int v7, long k8, int v8) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + k8);
        }
        map.put(k8, v8);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3, long k4, int v4, long k5, int v5, long k6, int v6, long k7, int v7, long k8, int v8, long k9, int v9) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + k9);
        }
        map.put(k9, v9);
        return map;
    }

    public static @NonNull TLongIntMap ofLongInt(int noEntryValue, long k1, int v1, long k2, int v2, long k3, int v3, long k4, int v4, long k5, int v5, long k6, int v6, long k7, int v7, long k8, int v8, long k9, int v9, long k10, int v10) {
        TLongIntMap map = MapUtils.ofLongInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + k10);
        }
        map.put(k10, v10);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue) {
        return new TLongLongHashMap(10, 0.5f, 0L, noEntryValue);
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue);
        map.put(k1, v1);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + k2);
        }
        map.put(k2, v2);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + k3);
        }
        map.put(k3, v3);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3, long k4, long v4) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + k4);
        }
        map.put(k4, v4);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3, long k4, long v4, long k5, long v5) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + k5);
        }
        map.put(k5, v5);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3, long k4, long v4, long k5, long v5, long k6, long v6) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + k6);
        }
        map.put(k6, v6);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3, long k4, long v4, long k5, long v5, long k6, long v6, long k7, long v7) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + k7);
        }
        map.put(k7, v7);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3, long k4, long v4, long k5, long v5, long k6, long v6, long k7, long v7, long k8, long v8) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + k8);
        }
        map.put(k8, v8);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3, long k4, long v4, long k5, long v5, long k6, long v6, long k7, long v7, long k8, long v8, long k9, long v9) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + k9);
        }
        map.put(k9, v9);
        return map;
    }

    public static @NonNull TLongLongMap ofLongLong(long noEntryValue, long k1, long v1, long k2, long v2, long k3, long v3, long k4, long v4, long k5, long v5, long k6, long v6, long k7, long v7, long k8, long v8, long k9, long v9, long k10, long v10) {
        TLongLongMap map = MapUtils.ofLongLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + k10);
        }
        map.put(k10, v10);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject() {
        return new TLongObjectHashMap();
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1) {
        TLongObjectMap<T> map = MapUtils.ofLongObject();
        map.put(k1, v1);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + k2);
        }
        map.put(k2, v2);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + k3);
        }
        map.put(k3, v3);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3, long k4, T v4) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + k4);
        }
        map.put(k4, v4);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3, long k4, T v4, long k5, T v5) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + k5);
        }
        map.put(k5, v5);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3, long k4, T v4, long k5, T v5, long k6, T v6) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + k6);
        }
        map.put(k6, v6);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3, long k4, T v4, long k5, T v5, long k6, T v6, long k7, T v7) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + k7);
        }
        map.put(k7, v7);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3, long k4, T v4, long k5, T v5, long k6, T v6, long k7, T v7, long k8, T v8) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + k8);
        }
        map.put(k8, v8);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3, long k4, T v4, long k5, T v5, long k6, T v6, long k7, T v7, long k8, T v8, long k9, T v9) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + k9);
        }
        map.put(k9, v9);
        return map;
    }

    public static <T> @NonNull TLongObjectMap<T> ofLongObject(long k1, T v1, long k2, T v2, long k3, T v3, long k4, T v4, long k5, T v5, long k6, T v6, long k7, T v7, long k8, T v8, long k9, T v9, long k10, T v10) {
        TLongObjectMap<T> map = MapUtils.ofLongObject(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + k10);
        }
        map.put(k10, v10);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue) {
        return new TObjectIntHashMap(10, 0.5f, noEntryValue);
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue);
        map.put(k1, v1);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k2));
        }
        map.put(k2, v2);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k3));
        }
        map.put(k3, v3);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3, T k4, int v4) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k4));
        }
        map.put(k4, v4);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3, T k4, int v4, T k5, int v5) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k5));
        }
        map.put(k5, v5);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3, T k4, int v4, T k5, int v5, T k6, int v6) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k6));
        }
        map.put(k6, v6);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3, T k4, int v4, T k5, int v5, T k6, int v6, T k7, int v7) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k7));
        }
        map.put(k7, v7);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3, T k4, int v4, T k5, int v5, T k6, int v6, T k7, int v7, T k8, int v8) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k8));
        }
        map.put(k8, v8);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3, T k4, int v4, T k5, int v5, T k6, int v6, T k7, int v7, T k8, int v8, T k9, int v9) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k9));
        }
        map.put(k9, v9);
        return map;
    }

    public static <T> @NonNull TObjectIntMap<T> ofObjectInt(int noEntryValue, T k1, int v1, T k2, int v2, T k3, int v3, T k4, int v4, T k5, int v5, T k6, int v6, T k7, int v7, T k8, int v8, T k9, int v9, T k10, int v10) {
        TObjectIntMap<T> map = MapUtils.ofObjectInt(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k10));
        }
        map.put(k10, v10);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue) {
        return new TObjectLongHashMap(10, 0.5f, noEntryValue);
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue);
        map.put(k1, v1);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1);
        if (map.containsKey(k2)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k2));
        }
        map.put(k2, v2);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2);
        if (map.containsKey(k3)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k3));
        }
        map.put(k3, v3);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3, T k4, long v4) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2, k3, v3);
        if (map.containsKey(k4)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k4));
        }
        map.put(k4, v4);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3, T k4, long v4, T k5, long v5) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4);
        if (map.containsKey(k5)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k5));
        }
        map.put(k5, v5);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3, T k4, long v4, T k5, long v5, T k6, long v6) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        if (map.containsKey(k6)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k6));
        }
        map.put(k6, v6);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3, T k4, long v4, T k5, long v5, T k6, long v6, T k7, long v7) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        if (map.containsKey(k7)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k7));
        }
        map.put(k7, v7);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3, T k4, long v4, T k5, long v5, T k6, long v6, T k7, long v7, T k8, long v8) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        if (map.containsKey(k8)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k8));
        }
        map.put(k8, v8);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3, T k4, long v4, T k5, long v5, T k6, long v6, T k7, long v7, T k8, long v8, T k9, long v9) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
        if (map.containsKey(k9)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k9));
        }
        map.put(k9, v9);
        return map;
    }

    public static <T> @NonNull TObjectLongMap<T> ofObjectLong(long noEntryValue, T k1, long v1, T k2, long v2, T k3, long v3, T k4, long v4, T k5, long v5, T k6, long v6, T k7, long v7, T k8, long v8, T k9, long v9, T k10, long v10) {
        TObjectLongMap<T> map = MapUtils.ofObjectLong(noEntryValue, k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
        if (map.containsKey(k10)) {
            throw new IllegalArgumentException("duplicate key: " + String.valueOf(k10));
        }
        map.put(k10, v10);
        return map;
    }

    public static <K, V> void putIfValueNotNull(@NonNull Map<@NonNull K, @NonNull V> map, @NonNull K k, @Nullable V v) {
        if (v != null) {
            map.put(k, v);
        }
    }

    public static <T> @NonNull Stream<@NonNull ObjIntPair<T>> stream(@NonNull TIntObjectMap<T> map) {
        return StreamSupport.stream(Spliterators.spliterator(MapUtils.iterator(map), (long)map.size(), 0), false);
    }
}

