/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.NullChecking;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LinuxUname {
    private static final @NonNull Pattern PATTERN = Pattern.compile("Linux ([^ ]+) (\\d+\\.[^ ]+) (.*) ([a-z][0-9a-z\\-_]+)( [^ ]*Linux)?");
    public final @NonNull String arch;
    public final @NonNull String date;
    public final @NonNull String machine;
    public final @NonNull String os;
    public final @NonNull String version;

    public static @Nullable LinuxUname parse(@NonNull String uname) {
        Matcher matcher = PATTERN.matcher(uname);
        if (!matcher.matches()) {
            return null;
        }
        @NonNull String machine = NullChecking.neverNull(matcher.group(1));
        @NonNull String version = NullChecking.neverNull(matcher.group(2));
        @NonNull String date = NullChecking.neverNull(matcher.group(3));
        @NonNull String arch = NullChecking.neverNull(matcher.group(4));
        @Nullable String os = matcher.group(5);
        return new LinuxUname(machine, version, date, arch, os != null ? os.trim() : "Linux");
    }

    public LinuxUname(@NonNull String machine, @NonNull String version, @NonNull String date, @NonNull String arch, @NonNull String os) {
        this.machine = machine;
        this.version = version;
        this.date = date;
        this.arch = arch;
        this.os = os;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinuxUname) {
            LinuxUname that = (LinuxUname)obj;
            return this.machine.contentEquals(that.machine) && this.version.contentEquals(that.version) && this.date.contentEquals(that.date) && this.arch.contentEquals(that.arch) && this.os.contentEquals(that.os);
        }
        return false;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return String.format("{machine = '%s', version = '%s', date = '%s', arch = '%s', os = '%s'}", this.machine, this.version, this.date, this.arch, this.os);
    }
}

