/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LazyConstructor<T> {
    private final @NonNull Supplier<? extends @NonNull T> constructor;
    private final @NonNull Object lock = new Object();
    private volatile @Nullable T value;

    public LazyConstructor(@NonNull Supplier<? extends @NonNull T> constructor) {
        this.constructor = constructor;
    }

    public void consumeIfAvailable(@NonNull Consumer<? super @NonNull T> consumer) {
        @Nullable T value = this.value;
        if (value != null) {
            consumer.accept(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull T get() {
        @Nullable T value = this.value;
        if (value == null) {
            Object object = this.lock;
            synchronized (object) {
                value = this.value;
                if (value == null) {
                    this.value = value = this.constructor.get();
                }
            }
        }
        return value;
    }

    public @Nullable T getIfAvailable() {
        return this.value;
    }
}

