/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.NullChecking;
import com.arm.utils.function.IBooleanConsumer;
import gnu.trove.TIntCollection;
import gnu.trove.TShortCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TShortIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IterUtils {
    public static void forEachBoolean(@NonNull IBooleanConsumer consumer) {
        consumer.accept(false);
        consumer.accept(true);
    }

    public static <T> boolean forEachInterruptable(@NonNull Iterable<? extends T> iterable, @NonNull BooleanSupplier interruptedSupplier, @NonNull Consumer<? super T> consumer) {
        for (T item : iterable) {
            if (interruptedSupplier.getAsBoolean()) {
                return false;
            }
            consumer.accept(item);
        }
        return true;
    }

    public static <T> boolean forEachInterruptable(T @NonNull [] array, @NonNull BooleanSupplier interruptedSupplier, @NonNull Consumer<? super T> consumer) {
        return IterUtils.forEachInterruptable(Arrays.asList(array), interruptedSupplier, consumer);
    }

    public static <T> T getNth(@NonNull Iterable<T> iterable, int n) {
        Iterator<T> it = iterable.iterator();
        int i = 0;
        while (i < n) {
            it.next();
            ++i;
        }
        return it.next();
    }

    public static <T> int indexOf(@NonNull Iterable<? super T> iterable, T object) {
        int index = 0;
        for (T item : iterable) {
            if (NullChecking.equalsNullable(object, item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static  @NonNull PrimitiveIterator.OfInt of(@NonNull TIntCollection collection) {
        return IterUtils.of(collection.iterator());
    }

    public static  @NonNull PrimitiveIterator.OfInt of(final @NonNull TIntIterator iterator) {
        return new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return iterator.next();
            }
        };
    }

    public static  @NonNull PrimitiveIterator.OfInt ofUnsigned(@NonNull TShortCollection collection) {
        return IterUtils.ofUnsigned(collection.iterator());
    }

    public static  @NonNull PrimitiveIterator.OfInt ofUnsigned(final @NonNull TShortIterator iterator) {
        return new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return Short.toUnsignedInt(iterator.next());
            }
        };
    }

    public static <T> @NonNull Iterable<@NonNull T> whileNotNull(@Nullable T first, final @NonNull Function<? super @NonNull T, ? extends @Nullable T> map) {
        return () -> new Iterator<T>(first){
            private @Nullable T next;
            {
                this.next = object;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                @Nullable T last = this.next;
                if (last == null) {
                    throw new NoSuchElementException();
                }
                this.next = map.apply(last);
                return last;
            }
        };
    }
}

