/*
 * Decompiled with CFR 0.152.
 */
package com.arm.databinding.conversion;

import com.arm.databinding.conversion.Messages;
import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;

public class DateTime {
    private static final @NonNull DateTimeFormatter DATE_TIME_PARSER = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final @NonNull DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final long NANOS_PER_SECOND = 1000000000L;

    public static long convertStringToUnixNanos(@NonNull String text) {
        Instant instant = Instant.from(DATE_TIME_PARSER.parse(text));
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    public static @NonNull String convertUnixNanosToString(long nanos) {
        Instant instant = Instant.ofEpochSecond(0L, nanos);
        return DATE_TIME_FORMATTER.format(instant);
    }

    public static class StringToUnixNanosConverter
    extends Converter<String, Long> {
        public StringToUnixNanosConverter() {
            super(String.class, Long.TYPE);
        }

        public Long convert(String fromObject) {
            return DateTime.convertStringToUnixNanos(fromObject);
        }
    }

    public static class StringValidator
    implements IValidator<String> {
        public IStatus validate(String value) {
            try {
                DateTime.convertStringToUnixNanos(value.trim());
                return ValidationStatus.ok();
            }
            catch (DateTimeParseException e) {
                String message = MessageFormat.format(Messages.DateTime_COULD_NOT_PARSE_0_EXPECTED, e.getParsedString().substring(e.getErrorIndex()));
                return ValidationStatus.error((String)message);
            }
        }
    }

    public static class UnixNanosToStringConverter
    extends Converter<Long, String> {
        public UnixNanosToStringConverter() {
            super(Long.TYPE, String.class);
        }

        public String convert(Long fromObject) {
            return DateTime.convertUnixNanosToString(fromObject);
        }
    }

    public static class UnixNanosValidator
    implements IValidator<Long> {
        public IStatus validate(Long value) {
            try {
                DateTime.convertUnixNanosToString(value);
                return ValidationStatus.ok();
            }
            catch (DateTimeException e) {
                return ValidationStatus.error((String)e.getLocalizedMessage());
            }
        }
    }
}

