/*
 * Decompiled with CFR 0.152.
 */
package com.arm.databinding;

import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicStringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.internal.databinding.observable.ConstantObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class ObservablePropertyLabelProvider<T>
extends LabelProvider
implements ITableLabelProvider,
ISetChangeListener<T>,
IValueChangeListener<String> {
    private final @NonNull IObservableSet<T> elements;
    private final @NonNull Map<IObservableValue<String>, Object> propertiesToOwningObjectMap = new HashMap<IObservableValue<String>, Object>();
    private final @NonNull List<@NonNull String> propertyNames;

    public ObservablePropertyLabelProvider(@NonNull ObservableListContentProvider<T> listContentProvider, String ... observablePropertyName) {
        this.elements = (IObservableSet)NullChecking.neverNull((Object)listContentProvider.getKnownElements());
        this.propertyNames = (List)NullChecking.neverNull(Arrays.asList(observablePropertyName));
        this.elements.addSetChangeListener((ISetChangeListener)this);
        this.registerValueChangeListeners((Set<?>)this.elements);
    }

    public void dispose() {
        this.elements.removeSetChangeListener((ISetChangeListener)this);
        this.unregisterValueChangeListener((Set<?>)this.elements);
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.propertyNames.size() > columnIndex) {
            @NonNull String fieldName = (String)NullChecking.neverNull((Object)this.propertyNames.get(columnIndex));
            IObservableValue<String> obsevableProperty = this.getObservableProperty(element, fieldName);
            return (String)obsevableProperty.getValue();
        }
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public void handleSetChange(SetChangeEvent<? extends T> event) {
        this.registerValueChangeListeners(event.diff.getAdditions());
        this.unregisterValueChangeListener(event.diff.getRemovals());
    }

    public void handleValueChange(ValueChangeEvent<? extends String> event) {
        Object sourceObject = this.propertiesToOwningObjectMap.get(event.getSource());
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, sourceObject));
    }

    protected IObservableValue<String> getObservableProperty(Object obj, @NonNull String name) {
        try {
            String capitalized = BasicStringUtils.capitalizeFirst((String)name);
            String accessorName = String.format("get%s", capitalized);
            Method m = obj.getClass().getMethod(accessorName, new Class[0]);
            return (IObservableValue)m.invoke(obj, new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            try {
                return (IObservableValue)obj.getClass().getField(name).get(obj);
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return new ConstantObservableValue((Object)"##propertyNotFound##", String.class);
    }

    private void registerValueChangeListeners(Set<?> set) {
        for (Object addition : set) {
            for (String propertyName : this.propertyNames) {
                IObservableValue<String> observable = this.getObservableProperty(addition, propertyName);
                observable.addValueChangeListener((IValueChangeListener)this);
                this.propertiesToOwningObjectMap.put(observable, addition);
            }
        }
    }

    private void unregisterValueChangeListener(Set<?> set) {
        if (set instanceof IObservableSet && ((IObservableSet)set).isDisposed()) {
            return;
        }
        for (Object removal : set) {
            for (String propertyName : this.propertyNames) {
                IObservableValue<String> observable = this.getObservableProperty(removal, propertyName);
                observable.addValueChangeListener((IValueChangeListener)this);
            }
        }
    }
}

