/*
 * Decompiled with CFR 0.152.
 */
package com.arm.databinding;

import com.arm.databinding.ImmutableListProperty;
import com.arm.utils.NullChecking;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.jdt.annotation.NonNull;

public class ImmutableObservableListFactory<T, U>
implements IObservableFactory<T, IObservableList<U>> {
    private final @NonNull Class<U> elementType;
    private final @NonNull ImmutableListProperty<T, U> listProperty;

    public ImmutableObservableListFactory(@NonNull Class<U> elementType, @NonNull Function<T, List<U>> getter) {
        this.elementType = elementType;
        this.listProperty = new ImmutableListProperty<T, U>(elementType, getter);
    }

    public IObservableList<U> createObservable(T target) {
        IObservableList list;
        Object listType;
        if (target == null) {
            throw new NullPointerException();
        }
        if (this.elementType.isAssignableFrom(target.getClass())) {
            return this.listProperty.observe(target);
        }
        if (target instanceof IObservableList && NullChecking.equalsNullable(this.elementType, (Object)(listType = (list = (IObservableList)target).getElementType()))) {
            return (IObservableList)target;
        }
        throw new UnsupportedOperationException();
    }
}

