/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.idle;

import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueConsumer;
import com.arm.streamline.analysis.processing.idle.IAnalysisIdleStateStreamModifierWriter;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class AnalysisIdleStateStreamModifierWriter
implements IAnalysisIdleStateStreamModifierWriter {
    private final @NonNull IAnalysisCounterValueConsumer counterWriter;
    private boolean currentlyIdle = false;
    private boolean firstEvent = true;
    private boolean firstWrite = true;
    private final @NonNull TLongList idleStateChangeTimestamps = new TLongArrayList();
    private final @NonNull TLongList idleStateChangeSequenceNos = new TLongArrayList();
    private long lastEventTimestamp = 0L;
    private long lastWriteTimestamp = 0L;

    private static long calculateActiveTime(boolean firstWrite, long onlineTimestamp, long idleTimestamp) {
        assert (firstWrite || idleTimestamp <= onlineTimestamp);
        return onlineTimestamp - idleTimestamp;
    }

    public AnalysisIdleStateStreamModifierWriter(@NonNull IAnalysisCounterValueConsumer counterWriter) {
        this.counterWriter = counterWriter;
    }

    @Override
    public void consumeCounterValue(long timestamp, long sequenceNo, long value) throws IOException {
        assert (this.firstEvent || this.lastEventTimestamp <= timestamp);
        this.firstEvent = false;
        this.lastEventTimestamp = timestamp;
        if (this.currentlyIdle) {
            this.addIdleEvent(timestamp, sequenceNo, false);
            assert (!this.currentlyIdle);
        }
        int size = this.idleStateChangeTimestamps.size();
        assert (size % 2 == 0);
        boolean writeLastValue = true;
        assert (this.idleStateChangeTimestamps.size() == this.idleStateChangeSequenceNos.size());
        if (size > 0) {
            long activeTime = AnalysisIdleStateStreamModifierWriter.calculateActiveTime(this.firstWrite, this.idleStateChangeTimestamps.get(0), this.lastWriteTimestamp);
            int i = 2;
            while (i < size) {
                long onlineTimestamp = this.idleStateChangeTimestamps.get(i);
                long idleTimestamp = this.idleStateChangeTimestamps.get(i - 1);
                activeTime += AnalysisIdleStateStreamModifierWriter.calculateActiveTime(this.firstWrite, onlineTimestamp, idleTimestamp);
                i += 2;
            }
            if ((activeTime += AnalysisIdleStateStreamModifierWriter.calculateActiveTime(this.firstWrite, timestamp, this.idleStateChangeTimestamps.get(size - 1))) != 0L) {
                long origValue = value;
                int i2 = 0;
                while (i2 < size) {
                    long previousOnlineTimestamp = i2 == 0 ? this.lastWriteTimestamp : this.idleStateChangeTimestamps.get(i2 - 1);
                    long idleTimestamp = this.idleStateChangeTimestamps.get(i2 + 0);
                    long onlineTimestamp = this.idleStateChangeTimestamps.get(i2 + 1);
                    long idleSeqNo = this.idleStateChangeSequenceNos.get(i2 + 0);
                    long onlineSeqNo = this.idleStateChangeSequenceNos.get(i2 + 1);
                    long timeActive = idleTimestamp - previousOnlineTimestamp;
                    long amountUsedBeforeIdle = origValue * timeActive / activeTime;
                    this.counterWriter.consumeCounterValue(idleTimestamp, idleSeqNo, amountUsedBeforeIdle);
                    this.counterWriter.consumeCounterValue(onlineTimestamp, onlineSeqNo, 0L);
                    value -= amountUsedBeforeIdle;
                    this.lastWriteTimestamp = onlineTimestamp;
                    this.firstWrite = false;
                    i2 += 2;
                }
                if (value == 0L && this.lastWriteTimestamp == timestamp) {
                    writeLastValue = false;
                }
            }
        }
        if (writeLastValue) {
            this.counterWriter.consumeCounterValue(timestamp, sequenceNo, value);
        }
        this.currentlyIdle = false;
        this.idleStateChangeTimestamps.clear();
        this.idleStateChangeSequenceNos.clear();
        this.lastWriteTimestamp = timestamp;
        this.firstWrite = false;
    }

    @Override
    public void consumeIdleEvent(long timestamp, long sequenceNo, boolean idle) throws IOException {
        assert (this.firstEvent || this.lastEventTimestamp <= timestamp);
        this.firstEvent = false;
        this.lastEventTimestamp = timestamp;
        assert (this.firstWrite || this.lastWriteTimestamp <= timestamp);
        this.addIdleEvent(timestamp, sequenceNo, idle);
    }

    private void addIdleEvent(long time, long sequenceNo, boolean idle) {
        if (idle != this.currentlyIdle) {
            this.currentlyIdle = idle;
            if (!this.idleStateChangeTimestamps.isEmpty()) {
                int count = this.idleStateChangeTimestamps.size();
                long lastTimestamp = this.idleStateChangeTimestamps.get(count - 1);
                assert (lastTimestamp <= time);
                if (idle && lastTimestamp == time) {
                    assert (count % 2 == 0);
                    this.idleStateChangeTimestamps.removeAt(count - 1);
                    this.idleStateChangeSequenceNos.removeAt(count - 1);
                    assert (this.idleStateChangeTimestamps.size() == this.idleStateChangeSequenceNos.size());
                    return;
                }
            }
            this.idleStateChangeTimestamps.add(time);
            this.idleStateChangeSequenceNos.add(sequenceNo);
            assert (this.idleStateChangeTimestamps.size() == this.idleStateChangeSequenceNos.size());
        }
    }
}

