/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.binning;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.processing.ClosableCachingStreamReaderAdapter;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterDataPointConsumer;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisHardwareCounterSupplier;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.ArrayUtils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnalysisIncidentBinningThreadCounterReader
implements IAnalysisBinningThreadCounterReader {
    private final @NonNull Processor processor;
    private final @NonNull ClosableCachingStreamReaderAdapter<IAnalysisHardwareCounterReader.Value, IAnalysisHardwareCounterSupplier> reader;

    public AnalysisIncidentBinningThreadCounterReader(@NonNull IAnalysisHardwareCounterSupplier reader) {
        this.reader = new ClosableCachingStreamReaderAdapter(reader);
        this.processor = new Processor(reader.getChannelCount());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int getChannelCount() {
        return ((IAnalysisHardwareCounterSupplier)this.reader.stream).getChannelCount();
    }

    @Override
    public void read(long upToTimestamp, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) throws IOException {
        IAnalysisHardwareCounterReader.Value value = (IAnalysisHardwareCounterReader.Value)this.reader.head();
        while (value != null && value.timestamp < upToTimestamp) {
            this.processor.insert(consumer, upToTimestamp, value.timestamp, value.channelIndex, value.utid, value.duration, value.value);
            value = (IAnalysisHardwareCounterReader.Value)this.reader.next();
        }
        this.processor.commit(consumer, upToTimestamp);
    }

    public static final class Processor
    implements IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor {
        private final @NonNull TIntLongMap @NonNull [] accumulators;

        private static void inc(@NonNull TIntLongMap map, @Nullable Integer utid, long value) {
            int key = IUniqueIds.mapNullableUtidToInt((Integer)utid);
            map.adjustOrPutValue(key, value, value);
        }

        private static void write(int channelIndex, @NonNull TIntLongMap map, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) throws IOException {
            TIntLongIterator it = map.iterator();
            while (it.hasNext()) {
                it.advance();
                int key = it.key();
                long value = it.value();
                @Nullable Integer utid = IUniqueIds.mapIntToNullableUtid((int)key);
                consumer.consumeCounterValue(channelIndex, utid, value, true);
            }
        }

        public Processor(int channelCount) {
            this.accumulators = (TIntLongMap[])ArrayUtils.createNonNull(TIntLongMap[]::new, (int)channelCount, i -> new TIntLongHashMap(1, 0.5f, -1, 0L));
        }

        @Override
        public void commit(@NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer, long binEndTimestamp) throws IOException {
            int i = 0;
            while (i < this.accumulators.length) {
                TIntLongMap map = this.accumulators[i];
                if (!map.isEmpty()) {
                    Processor.write(i, map, consumer);
                    map.clear();
                }
                ++i;
            }
        }

        @Override
        public void insert(@NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer, long binEndTimestamp, long timestamp, int channelNumber, @Nullable Integer utid, long duration, long value) throws IOException {
            TIntLongMap map = this.accumulators[channelNumber];
            Processor.inc(map, utid, value);
        }
    }
}

