/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.binning;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.processing.ClosableCachingStreamReaderAdapter;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterDataPointConsumer;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisHardwareCounterSupplier;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnalysisAbsoluteBinningThreadCounterReader
implements IAnalysisBinningThreadCounterReader {
    private final @NonNull Processor processor;
    private final @NonNull ClosableCachingStreamReaderAdapter<IAnalysisHardwareCounterReader.Value, IAnalysisHardwareCounterSupplier> reader;

    public AnalysisAbsoluteBinningThreadCounterReader(@NonNull IAnalysisHardwareCounterSupplier reader) {
        this.reader = new ClosableCachingStreamReaderAdapter(reader);
        this.processor = new Processor();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int getChannelCount() {
        return ((IAnalysisHardwareCounterSupplier)this.reader.stream).getChannelCount();
    }

    @Override
    public void read(long upToTimestamp, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) throws IOException {
        IAnalysisHardwareCounterReader.Value value = (IAnalysisHardwareCounterReader.Value)this.reader.head();
        while (value != null && value.timestamp < upToTimestamp) {
            this.processor.insert(consumer, upToTimestamp, value.timestamp, value.channelIndex, value.utid, value.duration, value.value);
            value = (IAnalysisHardwareCounterReader.Value)this.reader.next();
        }
    }

    public static final class Processor
    implements IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor {
        @Override
        public void commit(@NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer, long binEndTimestamp) {
        }

        @Override
        public void insert(@NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer, long binEndTimestamp, long timestamp, int channelNumber, @Nullable Integer utid, long duration, long value) throws IOException {
            consumer.consumeCounterValue(channelNumber, utid, value, true);
        }
    }
}

