/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.threads;

import com.arm.streamline.analysis.model.IMonotonicRawToVmTimestamp;
import com.arm.streamline.analysis.model.IVirtualMachineProperties;
import com.arm.streamline.analysis.model.threads.TProcess;
import com.arm.streamline.analysis.model.threads.TThread;
import com.arm.streamline.analysis.model.threads.ThreadLifeRange;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.NonUniqueId;
import com.arm.streamline.report.model.uids.UniqueIds;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ThreadTracker {
    private boolean mIsAndroid = false;
    private final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractPerVmId.PerVmNonUniqueTid, @NonNull List<@NonNull TThread>> mThreadMap = new HashMap<AbstractPerVmId.PerVmNonUniqueTid, List<TThread>>();
    private final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractPerVmId.PerVmCookie, @NonNull String> mVmToCookies = new HashMap<AbstractPerVmId.PerVmCookie, String>();
    private final @NonNull IThreadProperties properties;

    public ThreadTracker(@NonNull IThreadProperties properties) {
        this.properties = properties;
    }

    public void fork(long vmUID, long time, int ptid, @NonNull OptionalInt pid, int tid, boolean show) {
        TThread parentThread = this.getThread(vmUID, time, ptid);
        int cookie = parentThread.getLastCookieScan();
        String name = parentThread.getLastNameScan();
        this.putThreadName(vmUID, time, tid, name, show);
        this.putThreadCookie(vmUID, time, cookie, pid, tid, show);
    }

    public void free(long vmUID, long time, int tid, boolean show) {
        TThread thread = this.getThread(vmUID, time, tid);
        ThreadLifeRange threadRange = thread.observe(time);
        threadRange.setShow(show);
        TThread next = thread.split(time);
        if (next != null) {
            ((List)NullChecking.neverNull(this.mThreadMap.get(next.getId()))).add(next);
        }
    }

    public boolean isAndroid() {
        return this.mIsAndroid;
    }

    private static <T extends IVirtualMachineProperties & IMonotonicRawToVmTimestamp> long getTimestampAdjustmentFactor(@NonNull T vmProperties) {
        return vmProperties.isAnyTimesSeen() ? ((IMonotonicRawToVmTimestamp)vmProperties).toVmTimestamp(0L) : 0L;
    }

    public <T extends IVirtualMachineProperties & IMonotonicRawToVmTimestamp> @NonNull IUniqueIds processAll(@NonNull TLongObjectMap<T> vmStateData) {
        TreeSet<TThread> threads = new TreeSet<TThread>();
        for (List<TThread> list : this.mThreadMap.values()) {
            threads.addAll(list);
        }
        HashMap<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull AbstractPerVmId.PerVmNonUniquePid, @NonNull TProcess> lastProcessesById = new HashMap<AbstractPerVmId.PerVmNonUniquePid, TProcess>();
        ArrayList<@NonNull TProcess> processes = new ArrayList<TProcess>();
        for (TThread thread : threads) {
            thread.mergeObserved();
            // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractPerVmId.PerVmNonUniqueTid id = thread.getId();
            // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractPerVmId.PerVmNonUniquePid pid = new AbstractPerVmId.PerVmNonUniquePid(id.vmUID, thread.getLastPid().orElse(id.id));
            long cookieTime = thread.getLastCookieTime();
            // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractPerVmId.PerVmCookie cookie = new AbstractPerVmId.PerVmCookie(id.vmUID, thread.getLastCookie());
            @NonNull String threadName = thread.getLastName();
            @Nullable String cookieName = this.mVmToCookies.get(cookie);
            if (!this.mIsAndroid) {
                this.mIsAndroid = "system_server".equals(cookieName);
            }
            @Nullable IVirtualMachineProperties perVmState = (IVirtualMachineProperties)vmStateData.get(id.vmUID);
            long validEndTime = thread.getValid().getEndTime();
            long vmStart = perVmState != null ? perVmState.getVmStartTimestamp() : 0L;
            long vmAdjust = perVmState != null ? ThreadTracker.getTimestampAdjustmentFactor(perVmState) : 0L;
            long observedStartTime = thread.getObservedStartTime();
            long observedEndTime = thread.getObservedEndTime();
            long adjustedObservedStartTime = observedStartTime - vmAdjust;
            long adjustedObservedEndTime = observedEndTime - vmAdjust;
            boolean show = thread.isShow();
            if (adjustedObservedEndTime < vmStart || !show) continue;
            long startTime = adjustedObservedStartTime;
            long endTime = validEndTime == Long.MAX_VALUE ? Long.MAX_VALUE : adjustedObservedEndTime;
            NonUniqueId nonUtid = new NonUniqueId(startTime, endTime, (AbstractPerVmId.PerVmNonUniquePidOrTid)id, threadName.isEmpty() ? cookieName : threadName);
            TProcess process = (TProcess)lastProcessesById.get(pid);
            if (process == null || startTime > process.getValidEndTime()) {
                process = new TProcess(pid);
                processes.add(process);
                lastProcessesById.put(pid, process);
            }
            process.setCookie(cookieTime, cookie.id);
            process.addThread((NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>)nonUtid);
        }
        @NonNull HashMap<@NonNull K, @NonNull V> userThreadsToProcess = new HashMap();
        @NonNull HashMap<@NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
        AbstractPerVmId.PerVmNonUniqueTid>, @NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
        AbstractPerVmId.PerVmNonUniquePid>> kernelThreadsToProcess = new HashMap<NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>, NonUniqueId<AbstractPerVmId.PerVmNonUniquePid>>();
        @NonNull HashSet<@NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
        AbstractPerVmId.PerVmNonUniqueTid>> idleThreads = new HashSet<NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>>();
        for (TProcess process : processes) {
            boolean isKernel = process.getCookie() == -3;
            @NonNull NonUniqueId<// Could not load outer class - annotation placement on inner may be incorrect
            AbstractPerVmId.PerVmNonUniquePid> nonUpid = process.toNonUniqueId(this.mVmToCookies);
            for (NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid> nonUtid : process.getThreads()) {
                (isKernel ? kernelThreadsToProcess : userThreadsToProcess).put(nonUtid, nonUpid);
                // Could not load outer class - annotation placement on inner may be incorrect
                 @NonNull AbstractPerVmId.PerVmNonUniquePidOrTid vmThreadId = nonUtid.getId();
                if (vmThreadId.id != this.properties.getIdleTid(vmThreadId.vmUID)) continue;
                idleThreads.add(nonUtid);
            }
        }
        return new UniqueIds(userThreadsToProcess, kernelThreadsToProcess, idleThreads);
    }

    public void putCookieLabel(long vmUID, int cookie, @NonNull String label) {
        this.mVmToCookies.put(new AbstractPerVmId.PerVmCookie(vmUID, cookie), label);
    }

    public void putThread(long vmUID, long time, int tid, boolean show) {
        TThread thread = this.getThread(vmUID, time, tid);
        ThreadLifeRange threadRange = thread.observe(time);
        threadRange.setShow(show);
    }

    public void putThreadCookie(long vmUID, long time, int rawAppCookie, @NonNull OptionalInt rawPid, int tid, boolean show) {
        int appCookie = this.properties.getAppCookie(rawAppCookie, tid);
        @NonNull OptionalInt pid = OptionalUtils.map((OptionalInt)rawPid, p -> this.properties.getPid(p, appCookie));
        TThread thread = this.getThread(vmUID, time, tid);
        ThreadLifeRange threadRange = thread.observe(time);
        threadRange.setPid(time, pid, appCookie);
        threadRange.setShow(show);
    }

    public void putThreadName(long vmUID, long time, int tid, String name, boolean show) {
        TThread thread = this.getThread(vmUID, time, tid);
        ThreadLifeRange threadRange = thread.observe(time);
        threadRange.setName(time, name);
        threadRange.setShow(show);
    }

    private TThread findThread(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractPerVmId.PerVmNonUniqueTid id, long time) {
        @Nullable List<@NonNull TThread> threads = this.mThreadMap.get(id);
        if (threads == null) {
            return null;
        }
        for (TThread thread : threads) {
            if (thread.getValid().compareToPrecise(time) != 0) continue;
            return thread;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private TThread getThread(long vmUID, long time, int tid) {
        AbstractPerVmId.PerVmNonUniqueTid mapId = new AbstractPerVmId.PerVmNonUniqueTid(vmUID, tid);
        TThread thread = this.findThread(mapId, time);
        if (thread == null) {
            @NonNull @NonNull List threads = this.mThreadMap.computeIfAbsent(mapId, k -> new ArrayList());
            thread = new TThread(mapId, time);
            int insertPos = 0;
            while (insertPos < threads.size() && time > ((TThread)threads.get(insertPos)).getValid().getStartTime()) {
                ++insertPos;
            }
            if (insertPos > 0) {
                thread.getValid().setStartTime(((TThread)threads.get(insertPos - 1)).getValid().getEndTime() + 1L);
            }
            if (insertPos < threads.size()) {
                thread.getValid().setEndTime(((TThread)threads.get(insertPos)).getValid().getStartTime() - 1L);
            }
            threads.add(insertPos, thread);
        }
        return thread;
    }

    public static interface IThreadProperties {
        default public int getAppCookie(int rawAppCookie, int tid) {
            return rawAppCookie;
        }

        public int getIdleTid(long var1);

        default public int getPid(int rawPid, int appCookie) {
            return rawPid;
        }
    }
}

