/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.threads;

import com.arm.utils.OptionalUtils;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNull;

class ThreadLifeRange {
    static final long DELTA = 1000000000L;
    private int mCookie = -1;
    private long mCookieTime = Long.MIN_VALUE;
    private long mEndTime;
    private @NonNull String mName = "";
    private long mNameTime = Long.MIN_VALUE;
    private @NonNull OptionalInt mPid = OptionalInt.empty();
    private boolean mShow;
    private long mStartTime;

    public static boolean shouldUpdatePidAndCookie(long currentTime, int currentCookie, long newTime, int newCookie) {
        return currentCookie == -1 && currentTime <= newTime || currentCookie == -3 && currentTime >= newTime && newCookie >= 0 || currentCookie >= 0 && currentTime <= newTime && newCookie >= 0 || currentCookie == -3 && currentTime < newTime && newCookie != -1 || currentCookie == -1 && currentTime > newTime && newCookie != -1;
    }

    public ThreadLifeRange(long startTime, long endTime) {
        this.mStartTime = startTime;
        this.mEndTime = endTime;
    }

    public void check() {
        if (this.mStartTime > this.mEndTime) {
            throw new RuntimeException();
        }
    }

    public int compareToClose(long time) {
        if (time <= this.mStartTime - 1000000000L) {
            return -1;
        }
        if (time >= this.mEndTime + 1000000000L) {
            return 1;
        }
        return 0;
    }

    public int compareToPrecise(long time) {
        if (time < this.mStartTime) {
            return -1;
        }
        if (time > this.mEndTime) {
            return 1;
        }
        return 0;
    }

    public int getCookie() {
        return this.mCookie;
    }

    public long getCookieTime() {
        return this.mCookieTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public long getNameTime() {
        return this.mNameTime;
    }

    public @NonNull OptionalInt getPid() {
        return this.mPid;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public boolean isShow() {
        return this.mShow;
    }

    public void merge(ThreadLifeRange nextRange) {
        this.setEndTime(nextRange.getEndTime());
        this.setPid(nextRange.getCookieTime(), nextRange.getPid(), nextRange.getCookie());
        this.setName(nextRange.getNameTime(), nextRange.getName());
        this.setShow(nextRange.isShow());
    }

    public void setEndTime(long endTime) {
        this.mEndTime = endTime;
    }

    public void setName(long time, String name) {
        if (name != null && time >= this.mNameTime) {
            this.mNameTime = time;
            this.mName = name;
        }
    }

    public void setPid(long time, @NonNull OptionalInt pid, int cookie) {
        if (ThreadLifeRange.shouldUpdatePidAndCookie(this.mCookieTime, this.mCookie, time, cookie)) {
            this.mCookieTime = time;
            this.mPid = OptionalUtils.flatOrElse((OptionalInt)pid, (OptionalInt)this.mPid);
            this.mCookie = cookie;
        } else {
            this.mPid = OptionalUtils.flatOrElse((OptionalInt)this.mPid, (OptionalInt)pid);
        }
    }

    public void setShow(boolean show) {
        this.mShow |= show;
    }

    public void setStartTime(long startTime) {
        this.mStartTime = startTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.mPid);
        sb.append(":");
        sb.append(this.getStartTime());
        sb.append("-");
        sb.append(this.getEndTime());
        sb.append("]");
        return sb.toString();
    }
}

