/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.threads;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IExecutablePath {
    public static final @NonNull IExecutablePath IDLE = new SpecialExecutablePaths(Type.SPECIAL_IDLE, "<idle>");
    public static final @NonNull IExecutablePath KERNEL = new SpecialExecutablePaths(Type.SPECIAL_KERNEL, "<kernel>");
    public static final @NonNull IExecutablePath NONE = new SpecialExecutablePaths(Type.SPECIAL_NONE, "<none>");

    public static @NonNull IExecutablePath createFromPath(@NonNull String path) {
        return new ExecutablePath(path.replaceAll("[\\u0000-\\u001f]+$", ""));
    }

    public static @NonNull IExecutablePath createFromZipEntry(@NonNull String path, @NonNull String entry) {
        return new ZipExecutablePath(path, entry);
    }

    public @Nullable IExecutablePath asAbstractLeaf();

    public @Nullable String extractAndroidPackageName();

    public @NonNull String getBaseName();

    public @Nullable String getEntryPath();

    public @NonNull String getFullPath();

    public @NonNull Type getType();

    public boolean isAbstractPath();

    public @NonNull IExecutablePath removeLeaf();

    public static final class ExecutablePath
    implements IExecutablePath {
        private static final @NonNull Pattern ANDROID_PACKAGE_NAME_PATTERN = Pattern.compile("([0-9A-Za-z_]+(?:\\.[0-9A-Za-z_]+)+)(-.+==)?");
        private final @NonNull String basename;
        private final @NonNull String fullpath;
        private final boolean isAbstract;

        private static @Nullable String extractAndroidPackageNameFromPart(@NonNull String pathPart) {
            Matcher matcher = ANDROID_PACKAGE_NAME_PATTERN.matcher(pathPart);
            if (!matcher.matches()) {
                return null;
            }
            return matcher.group(1);
        }

        public ExecutablePath(@NonNull String rawPath) {
            int slashPos = rawPath.lastIndexOf(47);
            this.isAbstract = slashPos < 0;
            this.fullpath = rawPath;
            this.basename = rawPath.substring(slashPos + 1);
            if (this.fullpath.isEmpty() || this.basename.isEmpty()) {
                throw new IllegalArgumentException("Invalid executable path: " + this.fullpath + " (missing executable name)");
            }
        }

        @Override
        public @Nullable IExecutablePath asAbstractLeaf() {
            if (this.isAbstract) {
                assert (false);
                return this;
            }
            return new ExecutablePath(this.basename);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExecutablePath) {
                ExecutablePath that = (ExecutablePath)obj;
                return this.fullpath.contentEquals(that.fullpath);
            }
            return false;
        }

        @Override
        public @Nullable String extractAndroidPackageName() {
            if (this.isAbstract) {
                return null;
            }
            @NonNull String @NonNull [] pathParts = (String[])Arrays.stream(this.fullpath.split("/")).filter(p -> !p.isEmpty()).toArray(String[]::new);
            if (pathParts.length < 1 || !"data".contentEquals(pathParts[0])) {
                return null;
            }
            switch (pathParts[1]) {
                case "app": {
                    if (pathParts.length < 4) {
                        return null;
                    }
                    String result = ExecutablePath.extractAndroidPackageNameFromPart(pathParts[2]);
                    if (result != null) {
                        return result;
                    }
                    if (pathParts.length < 5) {
                        return null;
                    }
                    return ExecutablePath.extractAndroidPackageNameFromPart(pathParts[3]);
                }
                case "data": {
                    if (pathParts.length < 3) {
                        return null;
                    }
                    return ExecutablePath.extractAndroidPackageNameFromPart(pathParts[2]);
                }
                case "user": {
                    if (pathParts.length < 5) {
                        return null;
                    }
                    return ExecutablePath.extractAndroidPackageNameFromPart(pathParts[3]);
                }
            }
            if (pathParts.length < 3) {
                return null;
            }
            String pkg = ExecutablePath.extractAndroidPackageNameFromPart(pathParts[pathParts.length - 2]);
            String end = ExecutablePath.extractAndroidPackageNameFromPart(pathParts[pathParts.length - 1]);
            if (pkg != null && end != null && pkg.contentEquals(end)) {
                return pkg;
            }
            return null;
        }

        @Override
        public @NonNull String getBaseName() {
            return this.basename;
        }

        @Override
        public @Nullable String getEntryPath() {
            return null;
        }

        @Override
        public @NonNull String getFullPath() {
            return this.fullpath;
        }

        @Override
        public @NonNull Type getType() {
            return Type.FILE_OR_ZIP;
        }

        public int hashCode() {
            return this.fullpath.hashCode();
        }

        @Override
        public boolean isAbstractPath() {
            return this.isAbstract;
        }

        @Override
        public @NonNull IExecutablePath removeLeaf() {
            int slashPos = this.fullpath.lastIndexOf(47);
            if (this.isAbstract || slashPos < 0) {
                assert (false);
                return this;
            }
            return new ExecutablePath(this.fullpath.substring(0, slashPos));
        }

        public String toString() {
            return this.fullpath;
        }
    }

    public static class SpecialExecutablePaths
    implements IExecutablePath {
        private final @NonNull String title;
        private final @NonNull Type type;

        public SpecialExecutablePaths(@NonNull Type type, @NonNull String title) {
            this.type = type;
            this.title = title;
        }

        @Override
        public @Nullable IExecutablePath asAbstractLeaf() {
            assert (false);
            return this;
        }

        @Override
        public @Nullable String extractAndroidPackageName() {
            return null;
        }

        @Override
        public @NonNull String getBaseName() {
            return this.title;
        }

        @Override
        public @Nullable String getEntryPath() {
            return null;
        }

        @Override
        public @NonNull String getFullPath() {
            return this.title;
        }

        @Override
        public @NonNull Type getType() {
            return this.type;
        }

        @Override
        public boolean isAbstractPath() {
            return false;
        }

        @Override
        public @NonNull IExecutablePath removeLeaf() {
            assert (false);
            return this;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum Type {
        FILE_OR_ZIP,
        SPECIAL_IDLE,
        SPECIAL_KERNEL,
        SPECIAL_NONE;

    }

    public static final class ZipExecutablePath
    implements IExecutablePath {
        private final @NonNull String basename;
        private final @NonNull String entry;

        public ZipExecutablePath(@NonNull String rawPath, @NonNull String rawEntry) {
            int slashPos = rawPath.lastIndexOf(47);
            this.basename = rawPath.substring(slashPos + 1);
            if (this.basename.isEmpty()) {
                throw new IllegalArgumentException("Invalid executable path: " + rawPath + " (missing zip-file name)");
            }
            this.entry = rawEntry.replaceAll("^/+", "");
            if (this.entry.isEmpty() || this.entry.endsWith("/")) {
                throw new IllegalArgumentException("Invalid executable path: " + rawEntry + " (missing zip-entry name)");
            }
        }

        @Override
        public @Nullable IExecutablePath asAbstractLeaf() {
            assert (false);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ZipExecutablePath) {
                ZipExecutablePath that = (ZipExecutablePath)obj;
                return this.basename.contentEquals(that.basename) && this.entry.contentEquals(that.entry);
            }
            return false;
        }

        @Override
        public @Nullable String extractAndroidPackageName() {
            return null;
        }

        @Override
        public @NonNull String getBaseName() {
            return this.basename;
        }

        @Override
        public @NonNull String getEntryPath() {
            return this.entry;
        }

        @Override
        public @NonNull String getFullPath() {
            return this.basename;
        }

        @Override
        public @NonNull Type getType() {
            return Type.FILE_OR_ZIP;
        }

        public int hashCode() {
            return this.basename.hashCode() * 31 ^ this.entry.hashCode();
        }

        @Override
        public boolean isAbstractPath() {
            return true;
        }

        @Override
        public @NonNull IExecutablePath removeLeaf() {
            assert (false);
            return this;
        }

        public String toString() {
            return String.format("%s:%s", this.basename, this.entry);
        }
    }
}

