/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.utils.NullChecking;
import com.arm.utils.numbers.UnsignedLong;
import org.eclipse.jdt.annotation.NonNull;

public final class KernelSymbol
implements Comparable<KernelSymbol> {
    public final long address;
    public final @NonNull String module;
    public final @NonNull String symbol;
    public final char type;

    public KernelSymbol(@NonNull String module, @NonNull String symbol, char type, long address) {
        this.module = module;
        this.symbol = symbol;
        this.type = type;
        this.address = address;
    }

    @Override
    public int compareTo(@NonNull KernelSymbol o) {
        int result = UnsignedLong.compare((long)this.address, (long)o.address);
        if (result != 0) {
            return result;
        }
        result = this.module.compareTo(o.module);
        if (result != 0) {
            return result;
        }
        result = this.symbol.compareTo(o.symbol);
        if (result != 0) {
            return result;
        }
        return Character.compare(this.type, o.type);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KernelSymbol) {
            KernelSymbol that = (KernelSymbol)obj;
            return this.module.contentEquals(that.module) && this.symbol.contentEquals(that.symbol) && this.type == that.type && this.address == that.address;
        }
        return false;
    }

    public int hashCode() {
        return ((NullChecking.hashNullable((Object)this.module) * 31 + this.symbol.hashCode()) * 31 + Long.hashCode(this.address)) * 31 + Character.hashCode(this.type);
    }

    public String toString() {
        return String.format("KernelSymbol [module=%s, symbol=%s, address=0x%016x, type=%s]", this.module, this.symbol, this.address, Character.valueOf(this.type));
    }
}

