/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnnotationDataStructure {
    public static final @NonNull String EMPTY = "";
    private TIntObjectHashMap<AnnotationThreadStructure> mStructure = new TIntObjectHashMap();

    public void addChannelName(int utid, int channel, int group, String name, @Nullable Integer originalGroup, @Nullable Integer originalChannel) {
        AnnotationThreadStructure struct = this.getThread(utid);
        struct.mChannelNames.put(channel, (Object)name);
        struct.mGrouping.put(channel, group);
        if (originalGroup != null) {
            struct.mOriginalGroups.put(group, originalGroup.intValue());
        }
        if (originalChannel != null) {
            struct.mOriginalChannels.put(channel, originalChannel.intValue());
        }
    }

    public void addGroupName(int utid, int group, String name, @Nullable Integer originalGroup) {
        AnnotationThreadStructure struct = this.getThread(utid);
        struct.mGroupNames.put(group, (Object)name);
        if (originalGroup != null) {
            struct.mOriginalGroups.put(group, originalGroup.intValue());
        }
    }

    public boolean containsChannel(int utid, int channel, int group) {
        AnnotationThreadStructure struct = this.getThread(utid);
        return struct.mGrouping.contains(channel) && struct.mGrouping.get(channel) == group;
    }

    public @NonNull String getChannelName(int utid, int channel) {
        AnnotationThreadStructure struct = this.getThread(utid);
        String name = (String)struct.mChannelNames.get(channel);
        if (name == null) {
            return EMPTY;
        }
        return name;
    }

    public int[] getChannels(int utid) {
        AnnotationThreadStructure struct = this.getThread(utid);
        int[] channels = struct.mGrouping.keys();
        Arrays.sort(channels);
        return channels;
    }

    public int getGroup(int utid, int channel) {
        AnnotationThreadStructure struct = this.getThread(utid);
        return struct.mGrouping.get(channel);
    }

    public @NonNull String getGroupName(int utid, int group) {
        AnnotationThreadStructure struct = this.getThread(utid);
        String name = (String)struct.mGroupNames.get(group);
        if (name == null) {
            return EMPTY;
        }
        return name;
    }

    public int[] getGroups(int utid) {
        int[] channels;
        TreeSet<Integer> set = new TreeSet<Integer>();
        int[] nArray = channels = this.getChannels(utid);
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            int channel = nArray[n2];
            int group = this.getGroup(utid, channel);
            set.add(group);
            ++n2;
        }
        Integer[] array = set.toArray(new Integer[set.size()]);
        int[] groups = new int[array.length];
        int i = 0;
        while (i < array.length) {
            groups[i] = array[i];
            ++i;
        }
        return groups;
    }

    public AnnotationThreadStructure getThread(int utid) {
        AnnotationThreadStructure struct = (AnnotationThreadStructure)this.mStructure.get(utid);
        if (struct == null) {
            struct = new AnnotationThreadStructure();
            this.mStructure.put(utid, (Object)struct);
        }
        return struct;
    }

    public int[] getUtids() {
        return this.mStructure.keys();
    }

    public String toString() {
        int[] utids;
        String string = EMPTY;
        int[] nArray = utids = this.getUtids();
        int n = utids.length;
        int n2 = 0;
        while (n2 < n) {
            int[] groups;
            int utid = nArray[n2];
            AnnotationThreadStructure struct = this.getThread(utid);
            int[] nArray2 = groups = this.getGroups(utid);
            int n3 = groups.length;
            int n4 = 0;
            while (n4 < n3) {
                int[] channels;
                int group = nArray2[n4];
                int[] nArray3 = channels = this.getChannels(utid);
                int n5 = channels.length;
                int n6 = 0;
                while (n6 < n5) {
                    int channel = nArray3[n6];
                    if (this.containsChannel(utid, channel, group)) {
                        String line = "utid=" + utid + ", group=" + (String)struct.mGroupNames.get(group) + "(" + group + "), channel=" + (String)struct.mChannelNames.get(channel) + " (" + channel + ")\n";
                        string = string.concat(line);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return string;
    }

    public void weakLink(int utid, int channel, int group, @Nullable Integer originalChannel) {
        AnnotationThreadStructure struct = this.getThread(utid);
        if (!struct.mGrouping.contains(channel)) {
            struct.mGrouping.put(channel, group);
            if (originalChannel != null) {
                struct.mOriginalChannels.put(channel, originalChannel.intValue());
            }
        }
    }

    public @Nullable Integer getOriginalChannel(int thread, int channel) {
        AnnotationThreadStructure struct = this.getThread(thread);
        if (struct.mOriginalChannels.containsKey(channel)) {
            return struct.mOriginalChannels.get(channel);
        }
        return null;
    }

    public @Nullable Integer getOriginalGroup(int thread, int group) {
        AnnotationThreadStructure struct = this.getThread(thread);
        if (struct.mOriginalGroups.containsKey(group)) {
            return struct.mOriginalGroups.get(group);
        }
        return null;
    }

    private static class AnnotationThreadStructure {
        protected TIntObjectHashMap<String> mChannelNames = new TIntObjectHashMap();
        protected TIntObjectHashMap<String> mGroupNames = new TIntObjectHashMap();
        protected TIntIntHashMap mGrouping = new TIntIntHashMap();
        protected TIntIntHashMap mOriginalChannels = new TIntIntHashMap();
        protected TIntIntHashMap mOriginalGroups = new TIntIntHashMap();
    }
}

