/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.types;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.types.IndexAddress;
import org.eclipse.jdt.annotation.NonNull;

public class StreamMetadataBlobEntry
implements Comparable<StreamMetadataBlobEntry> {
    public final long token;
    public final @NonNull IndexAddress blobAddress;

    public static @NonNull StreamMetadataBlobEntry unpackOne(@NonNull PackedValueUnpacker unpacker) throws RuntimeException {
        long token = unpacker.unpackOneLong();
        IndexAddress blobAddress = IndexAddress.unpackOne(unpacker);
        return new StreamMetadataBlobEntry(token, blobAddress);
    }

    public StreamMetadataBlobEntry(long token, @NonNull IndexAddress blobAddress) {
        this.token = token;
        this.blobAddress = blobAddress;
    }

    @Override
    public int compareTo(StreamMetadataBlobEntry o) {
        if (this.token < o.token) {
            return -1;
        }
        if (this.token > o.token) {
            return 1;
        }
        if (this.blobAddress.offset < o.blobAddress.offset) {
            return -1;
        }
        if (this.blobAddress.offset > o.blobAddress.offset) {
            return 1;
        }
        return 0;
    }

    public @NonNull String toString() {
        return "StreamMetadataBlobEntry{token=" + this.token + ", blobAddress=" + String.valueOf(this.blobAddress) + "}";
    }
}

