/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.types;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import org.eclipse.jdt.annotation.NonNull;

public class IndexAddress {
    public final long offset;
    public final long size;

    public static @NonNull IndexAddress add(@NonNull IndexAddress a, @NonNull IndexAddress b) {
        return new IndexAddress(a.offset + b.offset, a.size + b.size);
    }

    public static @NonNull IndexAddress subtract(@NonNull IndexAddress a, @NonNull IndexAddress b) {
        return new IndexAddress(a.offset - b.offset, a.size - b.size);
    }

    public static @NonNull IndexAddress unpackOne(@NonNull PackedValueUnpacker unpacker) throws RuntimeException {
        long offset = unpacker.unpackOneLong();
        long size = unpacker.unpackOneLong();
        return new IndexAddress(offset, size);
    }

    public IndexAddress(long offset, long size) {
        this.offset = offset;
        this.size = size;
    }

    public @NonNull String toString() {
        return "IndexAddress{offset=" + this.offset + ", size=" + this.size + "}";
    }
}

