/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.database.v3.metadata.IExecutablePathsMap;
import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.DbConstants;
import com.arm.streamline.analysis.dbnative.stream.parser.IPrintable;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import gnu.trove.iterator.TByteShortIterator;
import gnu.trove.map.TByteShortMap;
import gnu.trove.map.hash.TByteShortHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SpeStreamParser
implements IStreamParser<StreamValue> {
    private static final byte flag_has_data_source = 2;
    private static final byte flag_has_events = 1;
    private static final byte flag_has_op_type = 4;
    private final @NonNull IExecutablePathsMap executablePathsMap;

    private static @NonNull SpeAddressAndTag parseAddress(@NonNull IExecutablePathsMap executablePathsMap, @NonNull PackedValueUnpacker unpacker) {
        long offset = unpacker.unpackOneLong();
        long pathId = unpacker.unpackOneLong();
        byte tag = unpacker.takeOneByte();
        IExecutablePath path = executablePathsMap.get(pathId);
        return new SpeAddressAndTag(tag, path, offset);
    }

    private static @NonNull TByteShortMap parseCounters(@NonNull PackedValueUnpacker unpacker) {
        TByteShortHashMap result = new TByteShortHashMap(0, 0.5f, 0, 0);
        long count = unpacker.unpackOneLong();
        long i = 0L;
        while (i < count) {
            byte key = unpacker.takeOneByte();
            short value = unpacker.unpackOneShort();
            result.put(key, value);
            ++i;
        }
        return result;
    }

    public SpeStreamParser(@NonNull IExecutablePathsMap executablePathsMap) {
        this.executablePathsMap = executablePathsMap;
    }

    @Override
    public StreamValue parseDataPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker unpacker) {
        int deviceNo = unpacker.unpackOneInt();
        long utid = unpacker.unpackOneLong();
        SpeAddressAndTag pc = SpeStreamParser.parseAddress(this.executablePathsMap, unpacker);
        TByteShortMap counters = SpeStreamParser.parseCounters(unpacker);
        long events = unpacker.unpackOneLong();
        short dataSources = unpacker.unpackOneShort();
        byte opTypeClazz = unpacker.takeOneByte();
        byte opTypeSubclazz = unpacker.takeOneByte();
        byte flags = unpacker.takeOneByte();
        return new StreamValue(index, deviceNo, utid, (flags & 4) == 4 ? new SpeOpTypeTuple(opTypeClazz, opTypeSubclazz) : null, (flags & 2) == 2 ? Short.valueOf(dataSources) : null, (flags & 1) == 1 ? Long.valueOf(events) : null, pc, counters);
    }

    public static final class SpeAddressAndTag {
        public final long offsetOrAddress;
        public final @Nullable IExecutablePath path;
        public final byte tag;

        public SpeAddressAndTag(byte tag, @Nullable IExecutablePath path, long offsetOrAddress) {
            this.tag = tag;
            this.path = path;
            this.offsetOrAddress = offsetOrAddress;
        }

        public String toString() {
            return String.format("%s :: 0x%x :: 0x%02x", this.path, this.offsetOrAddress, this.tag);
        }
    }

    public static final class SpeOpTypeTuple {
        public final byte clazz;
        public final byte subclazz;

        public SpeOpTypeTuple(byte clazz, byte subclazz) {
            this.clazz = clazz;
            this.subclazz = subclazz;
        }

        public String toString() {
            return String.format("0x%02x :: 0x%02x", this.clazz, this.subclazz);
        }
    }

    public static final class StreamValue
    implements IPrintable {
        public final @NonNull TByteShortMap counters;
        public final @Nullable Short dataSources;
        public final int deviceNo;
        public final @Nullable Long events;
        public final @NonNull IndexTimestampSeqno index;
        public final @Nullable SpeOpTypeTuple opType;
        public final @NonNull SpeAddressAndTag pc;
        public final @Nullable Integer utid;

        public StreamValue(@NonNull IndexTimestampSeqno index, int deviceNo, long utid, @Nullable SpeOpTypeTuple opType, @Nullable Short dataSources, @Nullable Long events, @NonNull SpeAddressAndTag pc, @NonNull TByteShortMap counters) {
            this.index = index;
            this.deviceNo = deviceNo;
            this.utid = DbConstants.toUtid(utid);
            this.opType = opType;
            this.dataSources = dataSources;
            this.events = events;
            this.pc = pc;
            this.counters = counters;
        }

        @Override
        public void printToStream(@NonNull Appendable a) throws IOException {
            a.append("        " + String.valueOf(this.index) + " :: " + String.format("%1$2s", this.deviceNo) + " :: " + String.format("%1$4s", this.utid) + " :: " + String.valueOf(this.opType) + " :: " + String.valueOf(this.dataSources) + " :: " + String.valueOf(this.events));
            a.append(System.lineSeparator());
            a.append("            pc :: " + String.valueOf(this.pc.path) + " :: " + this.pc.offsetOrAddress + " :: " + this.pc.tag);
            a.append(System.lineSeparator());
            TByteShortIterator it = this.counters.iterator();
            while (it.hasNext()) {
                it.advance();
                byte key = it.key();
                short value = it.value();
                a.append("            counter[" + Byte.toUnsignedInt(key) + "] :: " + Short.toUnsignedInt(value));
                a.append(System.lineSeparator());
            }
        }
    }
}

