/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.dbnative.stream.parser.OffsetsAddressesWithExecutablePaths;
import com.arm.streamline.analysis.dbnative.stream.parser.PerfSampleRegsAbi;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExecutableRelativeRegisterValues {
    private final @NonNull PerfSampleRegsAbi abi;
    private final boolean hostIs64Bit;
    private final @NonNull OffsetsAddressesWithExecutablePaths offsetsAndPaths;
    private final long @NonNull [] perfRegisterIndices;

    public ExecutableRelativeRegisterValues(@NonNull PerfSampleRegsAbi abi, long @NonNull [] perfRegIndices, long @NonNull [] registerOffsets, @Nullable IExecutablePath @NonNull [] executablePaths, boolean hostIs64Bit) {
        if (perfRegIndices.length != registerOffsets.length) {
            throw new IllegalArgumentException("Expected register indices array to be of same length as register offsets array");
        }
        if (registerOffsets.length != executablePaths.length) {
            throw new IllegalArgumentException("Expected register offsets array to be of same length as executable paths array");
        }
        this.abi = abi;
        this.perfRegisterIndices = perfRegIndices;
        this.offsetsAndPaths = new OffsetsAddressesWithExecutablePaths(executablePaths, registerOffsets);
        this.hostIs64Bit = hostIs64Bit;
    }

    public @NonNull PerfSampleRegsAbi getAbi() {
        return this.abi;
    }

    public @Nullable IExecutablePath @NonNull [] getExecutablePaths() {
        return this.offsetsAndPaths.getExecutablePaths();
    }

    public int getLength() {
        return this.offsetsAndPaths.getLength();
    }

    public long @NonNull [] getPerfRegisterIndices() {
        return this.perfRegisterIndices;
    }

    public long @NonNull [] getRegisterOffsetsOrAddresses() {
        return this.offsetsAndPaths.getRelOffsetsOrAddresses();
    }

    public boolean isHostIs64Bit() {
        return this.hostIs64Bit;
    }
}

