/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.database.v3.metadata.IExecutablePathsMap;
import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.ContextSwitchReason;
import com.arm.streamline.analysis.dbnative.stream.parser.DbConstants;
import com.arm.streamline.analysis.dbnative.stream.parser.ExecutableRelativeRegisterValues;
import com.arm.streamline.analysis.dbnative.stream.parser.IPrintable;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.stream.parser.OffsetsAddressesWithExecutablePaths;
import com.arm.streamline.analysis.dbnative.stream.parser.PerfSampleRegsAbi;
import com.arm.streamline.analysis.dbnative.stream.parser.SampleClassification;
import com.arm.streamline.analysis.dbnative.stream.parser.SampleCounterValues;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BacktraceStreamParser
implements IStreamParser<StreamValue> {
    private final @NonNull IExecutablePathsMap executablePaths;

    private static int expectArrayLength(String expectation, long castableToInt) {
        if (castableToInt > Integer.MAX_VALUE) {
            throw new IllegalStateException(expectation + " but encountered: " + castableToInt);
        }
        if (castableToInt < 0L) {
            throw new IllegalStateException(expectation + " but encountered: " + castableToInt);
        }
        return (int)castableToInt;
    }

    private static boolean expectBoolean(String expectation, long value) {
        if (value == 1L) {
            return true;
        }
        if (value == 0L) {
            return false;
        }
        throw new IllegalStateException(expectation + " but encountered: " + value);
    }

    private static String formatAddress(long address) {
        return String.format("0x%x", address);
    }

    private static @NonNull OffsetsAddressesWithExecutablePaths unpackAddressesArray(@NonNull IExecutablePathsMap executablePathsMap, @NonNull PackedValueUnpacker unpacker) {
        int addressesSize = BacktraceStreamParser.expectArrayLength("Expected 32-bit array length for backtrace addresses", unpacker.unpackOneLong());
        IExecutablePath[] executablePaths = new IExecutablePath[addressesSize];
        long[] addresses = new long[addressesSize];
        int n = 0;
        while (n < addressesSize) {
            long relativeOffsetOrAddress = unpacker.unpackOneLong();
            long unmappedPath = unpacker.unpackOneLong();
            executablePaths[n] = executablePathsMap.get(unmappedPath);
            addresses[n] = relativeOffsetOrAddress;
            ++n;
        }
        return new OffsetsAddressesWithExecutablePaths(executablePaths, addresses);
    }

    private static @NonNull SampleCounterValues unpackCountersInfo(@NonNull PackedValueUnpacker unpacker) {
        int countersSize = BacktraceStreamParser.expectArrayLength("Expected a 32-bit length for backtrace counters array", unpacker.unpackOneLong());
        int[] gatorKeys = new int[countersSize];
        long[] counterValues = new long[countersSize];
        int n = 0;
        while (n < countersSize) {
            int key = unpacker.unpackOneInt();
            long value = unpacker.unpackOneLong();
            gatorKeys[n] = key;
            counterValues[n] = value;
            ++n;
        }
        return new SampleCounterValues(gatorKeys, counterValues);
    }

    private static @NonNull ExecutableRelativeRegisterValues unpackRegistersInfo(@NonNull IExecutablePathsMap executablePathsMap, @NonNull PackedValueUnpacker unpacker) {
        PerfSampleRegsAbi abi = PerfSampleRegsAbi.fromLong(unpacker.unpackOneLong());
        int registersSize = BacktraceStreamParser.expectArrayLength("Expected a 32-bit length for backtrace registers array", unpacker.unpackOneLong());
        long[] perfRegisterIndices = new long[registersSize];
        long[] offsetArray = new long[registersSize];
        IExecutablePath[] executablePaths = new IExecutablePath[registersSize];
        int n = 0;
        while (n < registersSize) {
            perfRegisterIndices[n] = unpacker.unpackOneLong();
            offsetArray[n] = unpacker.unpackOneLong();
            executablePaths[n] = executablePathsMap.get(unpacker.unpackOneLong());
            ++n;
        }
        boolean hostIs64bit = BacktraceStreamParser.expectBoolean("Expected boolean for hostIs64Bit indicator", unpacker.unpackOneLong());
        return new ExecutableRelativeRegisterValues(abi, perfRegisterIndices, offsetArray, executablePaths, hostIs64bit);
    }

    public BacktraceStreamParser(@NonNull IExecutablePathsMap executablePaths) {
        this.executablePaths = executablePaths;
    }

    @Override
    public StreamValue parseDataPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker unpacker) {
        int deviceNo = unpacker.unpackOneInt();
        long utid = unpacker.unpackOneLong();
        SampleClassification classification = SampleClassification.fromInt(unpacker.unpackOneInt());
        ContextSwitchReason contextSwitchReason = ContextSwitchReason.fromInt(unpacker.unpackOneInt());
        ExecutableRelativeRegisterValues registerInfo = BacktraceStreamParser.unpackRegistersInfo(this.executablePaths, unpacker);
        OffsetsAddressesWithExecutablePaths addresses = BacktraceStreamParser.unpackAddressesArray(this.executablePaths, unpacker);
        SampleCounterValues counters = BacktraceStreamParser.unpackCountersInfo(unpacker);
        long duration = unpacker.unpackOneLong();
        return new StreamValue(index, deviceNo, utid, classification, contextSwitchReason, registerInfo, addresses, counters, duration);
    }

    public static final class StreamValue
    implements IPrintable {
        public final @NonNull OffsetsAddressesWithExecutablePaths addressesAndPathInfo;
        public final @NonNull SampleClassification classification;
        public final @NonNull ContextSwitchReason contextSwitchReason;
        public final @NonNull SampleCounterValues countersInfo;
        public final int deviceNo;
        public final @NonNull IndexTimestampSeqno index;
        public final @NonNull ExecutableRelativeRegisterValues registersInfo;
        public final @Nullable Integer utid;
        public final long duration;

        private static void printAddresses(Appendable a, @NonNull OffsetsAddressesWithExecutablePaths addressesAndPaths) throws IOException {
            int n = 0;
            while (n < addressesAndPaths.getLength()) {
                a.append("            address[" + String.format("%1$2s", n) + "] :: " + String.valueOf(addressesAndPaths.getExecutablePaths()[n]) + " :: " + BacktraceStreamParser.formatAddress(addressesAndPaths.getRelOffsetsOrAddresses()[n]));
                a.append(System.lineSeparator());
                ++n;
            }
        }

        private static void printCounters(@NonNull Appendable a, @NonNull SampleCounterValues counters) throws IOException {
            int n = 0;
            while (n < counters.getLength()) {
                a.append("            counter[" + String.format("%1$2s", n) + "] + " + counters.getGatorKeys()[n] + " :: " + counters.getCounterValues()[n]);
                a.append(System.lineSeparator());
                ++n;
            }
        }

        private static void printRegisters(Appendable a, @NonNull ExecutableRelativeRegisterValues registers) throws IOException {
            int n = 0;
            while (n < registers.getLength()) {
                a.append("            register[" + String.format("%1$2s", n) + "] :: " + registers.getPerfRegisterIndices()[n] + " :: " + String.valueOf(registers.getExecutablePaths()[n]) + " :: " + BacktraceStreamParser.formatAddress(registers.getRegisterOffsetsOrAddresses()[n]));
                a.append(System.lineSeparator());
                ++n;
            }
        }

        public StreamValue(@NonNull IndexTimestampSeqno index, int deviceNo, long utid, @NonNull SampleClassification classification, @NonNull ContextSwitchReason contextSwitchReason, @NonNull ExecutableRelativeRegisterValues registersInfo, @NonNull OffsetsAddressesWithExecutablePaths addressesAndPathInfo, @NonNull SampleCounterValues countersInfo, long duration) {
            this.index = index;
            this.deviceNo = deviceNo;
            this.utid = DbConstants.toUtid(utid);
            this.classification = classification;
            this.contextSwitchReason = contextSwitchReason;
            this.registersInfo = registersInfo;
            this.addressesAndPathInfo = addressesAndPathInfo;
            this.countersInfo = countersInfo;
            this.duration = duration;
        }

        @Override
        public void printToStream(@NonNull Appendable a) throws IOException {
            a.append(" " + String.valueOf(this.index) + " :: " + String.format("%1$2s", this.deviceNo) + " :: " + String.format("%1$4s", this.utid) + " :: " + String.valueOf((Object)this.classification) + " :: " + String.valueOf((Object)this.contextSwitchReason) + " :: " + this.addressesAndPathInfo.getLength() + " :: " + this.registersInfo.isHostIs64Bit() + " :: " + String.valueOf((Object)this.registersInfo.getAbi()) + " :: " + this.registersInfo.getLength());
            a.append(System.lineSeparator());
            StreamValue.printAddresses(a, this.addressesAndPathInfo);
            StreamValue.printCounters(a, this.countersInfo);
            StreamValue.printRegisters(a, this.registersInfo);
        }
    }
}

