/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.io;

import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class ByteBufferFiller {
    private final @NonNull ByteBuffer buffer;
    private final @NonNull IFileDataView source;
    private long offset;
    private long size;

    public ByteBufferFiller(@NonNull ByteBuffer buffer, long offset, @NonNull IFileDataView source) {
        this.buffer = buffer;
        this.source = source;
        this.offset = offset;
        this.size = source.fileSize();
        if (offset > this.size) {
            throw new IllegalArgumentException("Expected an offset less than or equal to the file size");
        }
    }

    public int tryEnsure(int lowWatermark) throws IOException {
        int readableBytes = this.buffer.remaining();
        if (readableBytes < lowWatermark) {
            this.buffer.compact();
            int writableBytes = this.buffer.remaining();
            long remainder = this.calcBytesRemaining();
            if (writableBytes == 0 && remainder > 0L) {
                throw new BufferOverflowException();
            }
            if (remainder > 0L) {
                @NonNull ByteBuffer chunk = this.source.getChunk(this.offset, Math.min((long)writableBytes, remainder));
                this.offset += (long)chunk.remaining();
                this.buffer.put(chunk);
            }
            this.buffer.flip();
        }
        return this.buffer.remaining();
    }

    private long calcBytesRemaining() {
        return this.size - this.offset;
    }
}

