/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.index;

import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.types.IndexAddress;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ChunkListReader {
    private final @NonNull List<@NonNull IndexAddress> chunkList;
    private @Nullable ByteBuffer currentChunk;
    private int currentChunkIndex;
    private final @NonNull IFileDataView data;

    public ChunkListReader(@NonNull IFileDataView data, @NonNull List<@NonNull IndexAddress> chunkList) throws IOException {
        this.data = data;
        this.chunkList = chunkList;
        this.currentChunkIndex = 0;
        this.currentChunk = null;
        this.loadChunk(0);
    }

    public long bytesRemaining() {
        if (this.currentChunk != null) {
            return this.currentChunk.remaining();
        }
        return 0L;
    }

    public @Nullable ByteBuffer currentChunk() {
        return this.currentChunk;
    }

    public int currentIndex() {
        return this.currentChunkIndex;
    }

    private boolean loadChunk(int nextChunkIndex) throws IOException, IndexOutOfBoundsException {
        if (nextChunkIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        do {
            if (nextChunkIndex >= this.chunkList.size()) {
                this.currentChunkIndex = this.chunkList.size();
                this.currentChunk = null;
                return false;
            }
            @NonNull IndexAddress address = this.chunkList.get(nextChunkIndex);
            this.currentChunkIndex = nextChunkIndex;
            this.currentChunk = this.data.getChunk(address.offset, address.size);
        } while (this.currentChunk == null);
        return true;
    }

    public boolean nextChunk() throws IOException, IndexOutOfBoundsException {
        return this.loadChunk(this.currentChunkIndex + 1);
    }

    public long size() {
        return this.chunkList.size();
    }
}

