/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.decoder;

import com.arm.streamline.common.utility.io.Compression;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public class PackedValueUnpacker {
    private final @NonNull ByteBuffer stream;

    public PackedValueUnpacker(@NonNull ByteBuffer stream) {
        this.stream = stream;
    }

    public byte takeOneByte() throws RuntimeException {
        return this.stream.get();
    }

    public int unpackOneInt() throws RuntimeException {
        long val = this.unpackOneLong();
        if (val < Integer.MIN_VALUE || val >= 0x100000000L) {
            throw new RuntimeException(String.format("Unpacked value %x is larger than int", val));
        }
        return (int)val;
    }

    public long unpackOneLong() throws RuntimeException {
        return Compression.unpackInt((ByteBuffer)this.stream);
    }

    public short unpackOneShort() throws RuntimeException {
        long val = this.unpackOneLong();
        if (val < -32768L || val >= 65536L) {
            throw new RuntimeException("Unpacked value is larger than short");
        }
        return (short)val;
    }

    public boolean takeOneBoolean() {
        byte val = this.stream.get();
        switch (val) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new RuntimeException("Unexpected value for boolean " + val);
    }

    public @NonNull String unpackOneUTF8String() throws RuntimeException {
        int stringViewLen = this.unpackOneInt();
        if (stringViewLen < 0) {
            throw new RuntimeException("Unexpected string size " + stringViewLen);
        }
        if (stringViewLen == 0) {
            return new String();
        }
        byte[] chars = new byte[stringViewLen];
        this.stream.get(chars, 0, stringViewLen);
        return new String(chars, StandardCharsets.UTF_8);
    }

    public byte[] unpackOneImage() throws RuntimeException {
        int imageLen = this.unpackOneInt();
        if (imageLen <= 0) {
            throw new RuntimeException("Unexpected image size " + imageLen);
        }
        byte[] bytes = new byte[imageLen];
        this.stream.get(bytes, 0, imageLen);
        return bytes;
    }
}

