/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3.metadata;

import com.arm.streamline.analysis.database.v3.metadata.IExecutablePathsMap;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExecutablePathsXmlReader
implements IExecutablePathsMap {
    public static final long ID_IDLE = 1L;
    public static final long ID_INVALID = -1L;
    public static final long ID_KERNEL = 2L;
    public static final long ID_NONE = 0L;
    private static final String ATTR_ID = "id";
    private static final String ATTR_PATH = "path";
    private static final String TAG_EXECUTABLE_PATHS = "executable_paths";
    private static final String TAG_PATH = "path";
    private final @NonNull TLongObjectMap<IExecutablePath> paths = new TLongObjectHashMap(10, 0.5f, -1L);

    private static @NonNull IExecutablePath create(long id, @NonNull String path) {
        if (id == 0L) {
            return IExecutablePath.NONE;
        }
        if (id == 1L) {
            return IExecutablePath.IDLE;
        }
        if (id == 2L) {
            return IExecutablePath.KERNEL;
        }
        return IExecutablePath.createFromPath(path);
    }

    public ExecutablePathsXmlReader(@NonNull File fullPath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(CommonFileUtils.getFile((File)fullPath));){
            this.populate(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected ExecutablePathsXmlReader(@NonNull InputStream is) throws IOException {
        this.populate(is);
    }

    private void populate(@NonNull InputStream is) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLParser in = XMLParser.create((InputStream)is);){
            String tag;
            while ((tag = in.nextTag()) != null) {
                if (!TAG_EXECUTABLE_PATHS.equals(tag)) {
                    throw new IOException("Invalid executable_paths.xml");
                }
                String marker = in.getMarker();
                while ((tag = in.nextTag(marker)) != null) {
                    if (!"path".equals(tag)) {
                        throw new IOException("Invalid executable_paths.xml");
                    }
                    long id = in.getLongAttribute(ATTR_ID, -1L);
                    String path = in.getAttribute("path", "");
                    if (id == -1L || path.isEmpty()) {
                        throw new IOException("Invalid executable_paths.xml");
                    }
                    IExecutablePath object = ExecutablePathsXmlReader.create(id, path);
                    IExecutablePath prev = (IExecutablePath)this.paths.put(id, (Object)object);
                    if (prev == null) continue;
                    throw new IOException("Invalid executable_paths.xml");
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.paths.put(0L, (Object)IExecutablePath.NONE);
        this.paths.put(1L, (Object)IExecutablePath.IDLE);
        this.paths.put(2L, (Object)IExecutablePath.KERNEL);
    }

    @Override
    public @Nullable IExecutablePath get(long id) {
        if (id == -1L) {
            return null;
        }
        IExecutablePath path = (IExecutablePath)this.paths.get(id);
        if (path == null) {
            throw new InvalidParameterException("Invalid path id " + id);
        }
        return path;
    }
}

