/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3.metadata;

import com.arm.streamline.analysis.database.v3.metadata.IDbCountersMap;
import com.arm.streamline.analysis.model.AtraceCounterSeriesKey;
import com.arm.streamline.analysis.model.CounterMap;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.metrics.MetricRecord;
import com.arm.streamline.common.model.chart.SeriesAliasUtils;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.common.xml.spe.SpeParsingException;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.common.xml.spe.SpeXMLParser;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.LongIntPair;
import com.arm.utils.collections.ObjIntPair;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CountersXmlReader
implements IDbCountersMap {
    private static final String ATTR_CODE = "code";
    private static final String ATTR_DEVICE_NO = "device_no";
    private static final String ATTR_EBS_BASED = "ebs_based";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_MAX_DEVICE_NO = "max_device_no";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SAMPLE_PERIOD = "sample_period";
    private static final String ATTR_SAMPLING_EVENT_KEY = "sampling_event_key";
    private static final String ATTR_STROBE_PERIOD = "strobe_period";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VM = "vm";
    private static final String TAG_ATRACE_COUNTER = "atrace_counter";
    private static final String TAG_COUNTERS = "counters";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_EVENT = "event";
    private static final String TAG_KERNEL_ANNOTATION_COUNTER = "kernel_annotation_counter";
    private static final String TAG_METRIC = "metric";
    private static final String TAG_SPE = "spe";
    private static final String TAG_STATIC_COUNTER = "static_counter";
    private static final String TAG_USERSPACE_ANNOTATION_COUNTER = "userspace_annotation_counter";
    private static final String TAG_VM = "vm";
    private final @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> atraceCounters = new TLongObjectHashMap(0, 0.5f, -1L);
    private final @NonNull CounterMap counterMap;
    private final @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> kernelAnnotationCounters = new TLongObjectHashMap(0, 0.5f, -1L);
    private int keyCounter;
    private final @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> metricEventCounters = new TLongObjectHashMap(0, 0.5f, -1L);
    private final @NonNull TLongObjectMap<TIntObjectMap<IDbCountersMap.MetricEventDetails>> metrics = new TLongObjectHashMap(0, 0.5f, -1L);
    private final @NonNull TLongObjectHashMap<TIntObjectHashMap<SpeTargetDescription>> speDescriptionMap = new TLongObjectHashMap(0, 0.5f, -1L);
    private final @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> staticCounters = new TLongObjectHashMap(0, 0.5f, -1L);
    private final @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> userspaceAnnotationCounters = new TLongObjectHashMap(0, 0.5f, -1L);

    private static @Nullable CounterRecord mapKey(long vm, int key, @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> counters) {
        TIntObjectMap map = (TIntObjectMap)counters.get(vm);
        if (map == null) {
            return null;
        }
        return (CounterRecord)map.get(key);
    }

    private static void populateMetricPerVmData(@NonNull XMLParser in, @NonNull CounterRecord counterRecord, @NonNull TLongObjectMap<TIntObjectMap<IDbCountersMap.MetricEventDetails>> metrics) throws IOException {
        String tag;
        String marker = in.getMarker();
        int limitDeviceNo = Math.max(counterRecord.getCores(), 1);
        block22: while ((tag = in.nextTag(marker)) != null) {
            switch (tag) {
                case "vm": {
                    String innerTag;
                    long vm = in.getLongAttribute("vm", 0L);
                    int maxDeviceNo = in.getIntegerAttribute(ATTR_MAX_DEVICE_NO, 0);
                    int metricKey = in.getIntegerAttribute(ATTR_KEY, 0);
                    int samplingEventKey = in.getIntegerAttribute(ATTR_SAMPLING_EVENT_KEY, 0);
                    int samplePeriod = in.getIntegerAttribute(ATTR_SAMPLE_PERIOD, 0);
                    int strobePeriod = in.getIntegerAttribute(ATTR_STROBE_PERIOD, 0);
                    boolean ebsBased = in.isAttributeSet(ATTR_EBS_BASED, false);
                    TIntObjectHashMap eventCodeToKeyAndName = new TIntObjectHashMap(10, 0.5f, -1);
                    if (maxDeviceNo >= limitDeviceNo) {
                        throw new IOException("Invalid counters.xml");
                    }
                    int returnEventKey = -1;
                    String innerMarker = in.getMarker();
                    while ((innerTag = in.nextTag(innerMarker)) != null) {
                        switch (innerTag) {
                            case "event": {
                                int eventCode = in.getIntegerAttribute(ATTR_CODE, 0);
                                int eventKey = in.getIntegerAttribute(ATTR_KEY, 0);
                                String typeStr = (String)NullChecking.neverNullOr((Object)in.getAttribute(ATTR_TYPE), (Object)"");
                                String nameStr = (String)NullChecking.neverNullOr((Object)in.getAttribute(ATTR_NAME), (Object)"");
                                switch (typeStr) {
                                    case "cycles": {
                                        assert (eventKey == samplingEventKey);
                                        break;
                                    }
                                    case "return": {
                                        assert (returnEventKey == -1);
                                        returnEventKey = eventKey;
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError((Object)("What metric type is " + typeStr));
                                    }
                                    case "": 
                                }
                                eventCodeToKeyAndName.put(eventCode, (Object)new ObjIntPair((Object)(nameStr.isBlank() ? null : nameStr), eventKey));
                                break;
                            }
                        }
                    }
                    if (vm != 0L) {
                        throw new AssertionError((Object)"Unexpected VM value");
                    }
                    MetricRecord metricRecord = new MetricRecord(counterRecord, metricKey, samplingEventKey, returnEventKey, samplePeriod, strobePeriod, ebsBased, (TIntObjectHashMap<ObjIntPair<String>>)eventCodeToKeyAndName);
                    TIntObjectMap mapEventKeyToMetrics = (TIntObjectMap)metrics.get(vm);
                    if (mapEventKeyToMetrics == null) {
                        mapEventKeyToMetrics = new TIntObjectHashMap(0, 0.5f, -1);
                        metrics.put(vm, (Object)mapEventKeyToMetrics);
                    }
                    TIntObjectIterator it = eventCodeToKeyAndName.iterator();
                    while (it.hasNext()) {
                        it.advance();
                        int eventCode = it.key();
                        ObjIntPair eventKeyAndName = (ObjIntPair)it.value();
                        int eventKey = eventKeyAndName.second;
                        String eventName = (String)eventKeyAndName.first;
                        IDbCountersMap.MetricEventDetails set = (IDbCountersMap.MetricEventDetails)mapEventKeyToMetrics.get(eventKey);
                        if (set == null) {
                            set = new IDbCountersMap.MetricEventDetails(eventCode);
                            mapEventKeyToMetrics.put(eventKey, (Object)set);
                        }
                        if (eventName != null) {
                            set.eventNames().add(eventName);
                        }
                        set.associatedMetrics().add(metricRecord);
                    }
                    continue block22;
                }
                default: {
                    throw new IOException("Invalid counters.xml");
                }
            }
        }
    }

    private static void populatePerVmData(@NonNull XMLParser in, @NonNull ProcessingElementReferenceSet processingElementReferences, @NonNull CounterRecord counterRecord, @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> counters) throws IOException {
        String tag;
        TreeSet<ProcessingElementReference> channels = new TreeSet<ProcessingElementReference>();
        DeviceType deviceType = counterRecord.getDeviceTypeOrDefault();
        int limitDeviceNo = Math.max(counterRecord.getCores(), 1);
        String marker = in.getMarker();
        block6: while ((tag = in.nextTag(marker)) != null) {
            switch (tag) {
                case "vm": {
                    CounterRecord prev;
                    long vm = in.getLongAttribute("vm", 0L);
                    int key = in.getIntegerAttribute(ATTR_KEY, 0);
                    int maxDeviceNo = in.getIntegerAttribute(ATTR_MAX_DEVICE_NO, 0);
                    if (vm != 0L) {
                        throw new AssertionError((Object)"Unexpected VM value");
                    }
                    if (maxDeviceNo >= limitDeviceNo) {
                        throw new IOException("Invalid counters.xml");
                    }
                    int i = 0;
                    while (i < limitDeviceNo) {
                        channels.add(processingElementReferences.get(deviceType, vm, i));
                        ++i;
                    }
                    TIntObjectMap map = (TIntObjectMap)counters.get(vm);
                    if (map == null) {
                        map = new TIntObjectHashMap(0, 0.5f, -1);
                        counters.put(vm, (Object)map);
                    }
                    if ((prev = (CounterRecord)map.put(key, (Object)counterRecord)) == null) continue block6;
                    throw new IOException("Invalid counters.xml");
                }
                default: {
                    throw new IOException("Invalid counters.xml");
                }
            }
        }
        counterRecord.setChannelDescriptions((ProcessingElementReference[])channels.toArray(ProcessingElementReference[]::new));
    }

    public CountersXmlReader(@NonNull File fullPath, @NonNull ProcessingElementReferenceSet processingElementReferences, @NonNull DeviceTypeCalculator deviceTypeCalculator) throws IOException, BadXmlException {
        this.counterMap = new CounterMap(deviceTypeCalculator);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream is = new FileInputStream(CommonFileUtils.getFile((File)fullPath));){
            this.populate(is, processingElementReferences);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected CountersXmlReader(@NonNull InputStream is, @NonNull ProcessingElementReferenceSet processingElementReferences, @NonNull DeviceTypeCalculator deviceTypeCalculator) throws IOException, BadXmlException {
        this.counterMap = new CounterMap(deviceTypeCalculator);
        this.populate(is, processingElementReferences);
    }

    @Override
    public CounterMap getCounterMap() {
        return this.counterMap;
    }

    @Override
    public @NonNull TLongObjectMap<TIntObjectMap<IDbCountersMap.MetricEventDetails>> getMetricsMap() {
        return this.metrics;
    }

    @Override
    public @NonNull TLongObjectHashMap<TIntObjectHashMap<SpeTargetDescription>> getSpeDescriptionMap() {
        return this.speDescriptionMap;
    }

    @Override
    public CounterRecord mapAtraceCounterSeriesKey(long vm, int key) {
        return CountersXmlReader.mapKey(vm, key, this.atraceCounters);
    }

    @Override
    public CounterRecord mapKernelAnnotationCounterSeriesKey(long vm, int key) {
        return CountersXmlReader.mapKey(vm, key, this.kernelAnnotationCounters);
    }

    @Override
    public @Nullable CounterRecord mapMetricEventCounterSeriesKey(long vm, int key) {
        return CountersXmlReader.mapKey(vm, key, this.metricEventCounters);
    }

    @Override
    public CounterRecord mapStaticCounterSeriesKey(long vm, int key) {
        return CountersXmlReader.mapKey(vm, key, this.staticCounters);
    }

    @Override
    public CounterRecord mapUserspaceAnnotationCounterSeriesKey(long vm, int key) {
        return CountersXmlReader.mapKey(vm, key, this.userspaceAnnotationCounters);
    }

    private void populate(@NonNull InputStream is, @NonNull ProcessingElementReferenceSet processingElementReferences) throws IOException, BadXmlException {
        Throwable throwable = null;
        Object var4_6 = null;
        try (XMLParser in = XMLParser.create((InputStream)is);){
            String tag;
            while ((tag = in.nextTag()) != null) {
                if (!TAG_COUNTERS.equals(tag)) {
                    throw new IOException("Invalid counters.xml");
                }
                String marker = in.getMarker();
                while ((tag = in.nextTag(marker)) != null) {
                    switch (tag) {
                        case "metric": {
                            this.processMetric(in);
                            break;
                        }
                        case "static_counter": {
                            this.processStaticCounter(in, processingElementReferences);
                            break;
                        }
                        case "userspace_annotation_counter": {
                            this.processUserspaceAnnotationCounter(in, processingElementReferences);
                            break;
                        }
                        case "kernel_annotation_counter": {
                            this.processKernelAnnotationCounter(in, processingElementReferences);
                            break;
                        }
                        case "atrace_counter": {
                            this.processAtraceCounter(in, processingElementReferences);
                            break;
                        }
                        case "spe": {
                            this.processSpe(in);
                            break;
                        }
                        default: {
                            throw new IOException("Invalid counters.xml");
                        }
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int totalPossibleMetricDeviceCharts = 0;
        TLongObjectIterator metricsIt = this.metrics.iterator();
        while (metricsIt.hasNext()) {
            metricsIt.advance();
            TIntObjectMap mapEventKeyToMetrics = (TIntObjectMap)metricsIt.value();
            TIntObjectIterator eventIt = mapEventKeyToMetrics.iterator();
            while (eventIt.hasNext()) {
                eventIt.advance();
                IDbCountersMap.MetricEventDetails metricsAndCode = (IDbCountersMap.MetricEventDetails)eventIt.value();
                Set<MetricRecord> metrics = metricsAndCode.associatedMetrics();
                int limitDeviceNo = metrics.stream().mapToInt(m -> Math.max(1, m.counterRecord().getCores())).max().orElse(1);
                totalPossibleMetricDeviceCharts += limitDeviceNo;
            }
        }
        boolean forceSystemWide = totalPossibleMetricDeviceCharts > 64;
        TLongObjectIterator metricsIt2 = this.metrics.iterator();
        while (metricsIt2.hasNext()) {
            metricsIt2.advance();
            long vmUID = metricsIt2.key();
            TIntObjectMap mapEventKeyToMetrics = (TIntObjectMap)metricsIt2.value();
            TIntObjectIterator eventIt = mapEventKeyToMetrics.iterator();
            while (eventIt.hasNext()) {
                ProcessingElementReference[] channels;
                eventIt.advance();
                int eventKey = eventIt.key();
                IDbCountersMap.MetricEventDetails metricsAndCode = (IDbCountersMap.MetricEventDetails)eventIt.value();
                int eventCode = metricsAndCode.eventCode();
                Set<String> eventNames = metricsAndCode.eventNames();
                Set<MetricRecord> metrics = metricsAndCode.associatedMetrics();
                String suffixToUse = eventNames.stream().collect(Collectors.joining("___and___"));
                StringBuilder descriptionToUse = new StringBuilder();
                int nameCount = 0;
                for (String name : eventNames) {
                    if (nameCount > 0 && nameCount + 1 < eventNames.size()) {
                        descriptionToUse.append(", ");
                    } else if (nameCount > 0) {
                        descriptionToUse.append(", and ");
                    } else if (eventNames.size() > 1) {
                        descriptionToUse.append("Raw event counters for metric events ");
                    } else {
                        descriptionToUse.append("Raw event counters for metric event ");
                    }
                    descriptionToUse.append(name);
                    ++nameCount;
                }
                Set clusters = metrics.stream().map(m -> m.counterRecord().getCluster()).collect(Collectors.toSet());
                assert (clusters.size() < 2);
                int limitDeviceNo = metrics.stream().mapToInt(m -> Math.max(1, m.counterRecord().getCores())).max().orElse(1);
                if (forceSystemWide) {
                    channels = new ProcessingElementReference[]{processingElementReferences.get(DeviceType.SYSTEM_WIDE, vmUID, 0)};
                } else {
                    channels = new ProcessingElementReference[limitDeviceNo];
                    int i = 0;
                    while (i < limitDeviceNo) {
                        channels[i] = processingElementReferences.get(DeviceType.CPU, vmUID, i);
                        ++i;
                    }
                }
                CounterRecord counterRecord = new CounterRecord(String.format("metric_event_data___%x_%04x_%s", eventKey, eventCode, suffixToUse).replaceAll("[^0-9a-zA-Z]", "_"), "Raw metric event data", String.format("Raw event # %x", eventKey), descriptionToUse.toString(), null);
                counterRecord.setDerived(true);
                counterRecord.setChannelDescriptions(channels);
                counterRecord.setCounterClass(CounterClass.DELTA);
                counterRecord.setDeviceType(forceSystemWide ? DeviceType.SYSTEM_WIDE : DeviceType.CPU);
                counterRecord.setMode(forceSystemWide ? CounterMode.SYSTEM_WIDE : CounterMode.PER_CORE);
                counterRecord.setCores(forceSystemWide ? 1 : limitDeviceNo);
                counterRecord.setCluster(forceSystemWide || clusters.isEmpty() ? null : (Integer)clusters.iterator().next());
                counterRecord.setProc(Ternary.TRUE);
                counterRecord.setDisplay(CounterDisplay.ACCUMULATE);
                counterRecord.setHideByDefault(true);
                for (MetricRecord metric : metrics) {
                    String eventName;
                    ObjIntPair entry = (ObjIntPair)metric.eventCodeToKeyAndName().get(eventCode);
                    if (entry == null || (eventName = (String)entry.first) == null) continue;
                    String counterSetPart = metric.counterRecord().getCounter().replaceAll("ARM[^_]+_(.+)_metric_.*", "$1");
                    String titleAndCpu = String.format("%s (%s)", metric.counterRecord().getName(), counterSetPart.replace('_', '-'));
                    String alias = SeriesAliasUtils.createAlias((String)titleAndCpu, (String)eventName);
                    String aliasWithCluster = SeriesAliasUtils.createAlias((String)titleAndCpu, (String)eventName, (Integer)counterRecord.getCluster());
                    counterRecord.addAdditionalAlias(alias);
                    counterRecord.addAdditionalAlias(aliasWithCluster);
                }
                TIntObjectMap counterRecords = (TIntObjectMap)this.metricEventCounters.get(vmUID);
                if (counterRecords == null) {
                    counterRecords = new TIntObjectHashMap(10, 0.5f, -1);
                    this.metricEventCounters.put(vmUID, (Object)counterRecords);
                }
                counterRecords.put(eventKey, (Object)counterRecord);
            }
        }
    }

    private void processAtraceCounter(@NonNull XMLParser in, @NonNull ProcessingElementReferenceSet processingElementReferences) throws IOException {
        String name = in.getAttribute(ATTR_NAME, "");
        if (name.isEmpty()) {
            throw new IOException("Invalid counters.xml");
        }
        CounterRecord counterRecord = AtraceCounterSeriesKey.makeCounterRecord(name);
        CountersXmlReader.populatePerVmData(in, processingElementReferences, counterRecord, this.atraceCounters);
        this.counterMap.add(counterRecord);
    }

    private void processCounterRecord(@NonNull XMLParser in, @NonNull ProcessingElementReferenceSet processingElementReferences, @NonNull String namePrefix, @NonNull TLongObjectMap<TIntObjectMap<CounterRecord>> counters) throws IOException, BadXmlException {
        CounterRecord counterRecord = new CounterRecord(in, (i, t) -> null);
        CountersXmlReader.populatePerVmData(in, processingElementReferences, counterRecord, counters);
        String oldId = counterRecord.getCounter();
        if (oldId == null) {
            counterRecord.setCounter(namePrefix + this.keyCounter);
        }
        counterRecord.setKey(++this.keyCounter);
        this.counterMap.add(counterRecord);
    }

    private void processKernelAnnotationCounter(@NonNull XMLParser in, @NonNull ProcessingElementReferenceSet processingElementReferences) throws IOException, BadXmlException {
        this.processCounterRecord(in, processingElementReferences, "__kernel_annotations_", this.kernelAnnotationCounters);
    }

    private void processMetric(@NonNull XMLParser in) throws IOException, BadXmlException {
        CounterRecord counterRecord = new CounterRecord(in, (i, t) -> null);
        CountersXmlReader.populateMetricPerVmData(in, counterRecord, this.metrics);
        String oldId = counterRecord.getCounter();
        if (oldId == null) {
            counterRecord.setCounter("__metric_" + this.keyCounter);
        }
        counterRecord.setKey(++this.keyCounter);
    }

    private void processSpe(@NonNull XMLParser in) throws IOException, SpeParsingException {
        String tag;
        HashMap speTargetDescriptionMap = new HashMap();
        Predicate<@NonNull String> validSpesPredicate = name -> true;
        HashSet<LongIntPair> deviceNoSet = new HashSet<LongIntPair>();
        SpeTargetDescription targetDescription = null;
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            switch (tag) {
                case "description": {
                    if (targetDescription != null) {
                        throw new IOException("Invalid <spe> element in counters.xml");
                    }
                    targetDescription = SpeXMLParser.parseSpeEventsXML((XMLParser)in, speTargetDescriptionMap, validSpesPredicate);
                    break;
                }
                case "vm": {
                    long vm = in.getLongAttribute("vm");
                    int deviceNo = in.getIntegerAttribute(ATTR_DEVICE_NO);
                    deviceNoSet.add(new LongIntPair(vm, deviceNo));
                    break;
                }
                default: {
                    throw new IOException("Invalid counters.xml");
                }
            }
        }
        if (targetDescription == null || deviceNoSet.isEmpty()) {
            throw new IOException("Invalid <spe> element in counters.xml");
        }
        for (LongIntPair entry : deviceNoSet) {
            SpeTargetDescription oldValue;
            TIntObjectHashMap deviceMap = (TIntObjectHashMap)this.getSpeDescriptionMap().get(entry.first);
            if (deviceMap == null) {
                deviceMap = new TIntObjectHashMap(10, 0.5f, -1);
                this.getSpeDescriptionMap().put(entry.first, (Object)deviceMap);
            }
            if ((oldValue = (SpeTargetDescription)deviceMap.put(entry.second, (Object)targetDescription)) == null) continue;
            throw new IOException("Invalid <spe> element in counters.xml");
        }
    }

    private void processStaticCounter(@NonNull XMLParser in, @NonNull ProcessingElementReferenceSet processingElementReferences) throws IOException, BadXmlException {
        this.processCounterRecord(in, processingElementReferences, "__static_counters_", this.staticCounters);
    }

    private void processUserspaceAnnotationCounter(@NonNull XMLParser in, @NonNull ProcessingElementReferenceSet processingElementReferences) throws IOException, BadXmlException {
        this.processCounterRecord(in, processingElementReferences, "__userspace_counters_", this.userspaceAnnotationCounters);
    }
}

