/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.v3.AbstractDatabaseVmStreamReader;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.CounterStreamParser;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.utils.function.IThrowingSupplier;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterReader
extends AbstractDatabaseVmStreamReader<IAnalysisHardwareCounterReader.Value, StreamValue>
implements IAnalysisHardwareCounterReader {
    private final @NonNull ProcessingElementReference @NonNull [] channels;

    public DatabaseCounterReader(@NonNull ProcessingElementReference @NonNull [] channels, @NonNull List<@NonNull VmStream> vmStreams) {
        super(vmStreams);
        this.channels = channels;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getChannelCount() {
        return this.channels.length;
    }

    @Override
    public @Nullable IAnalysisHardwareCounterReader.Value read() throws IOException {
        return (IAnalysisHardwareCounterReader.Value)this.doRead();
    }

    @Override
    protected @NonNull IAnalysisHardwareCounterReader.Value mapStreamValue(@NonNull StreamValue value) {
        return value.value;
    }

    public static final class StreamValue
    implements AbstractDatabaseVmStreamReader.IStreamValue {
        public final @NonNull IAnalysisHardwareCounterReader.Value value;

        public StreamValue(int channelBase, int deviceNoCount, boolean systemWide, @NonNull CounterStreamParser.StreamValue streamValue) {
            assert (streamValue.deviceNo < deviceNoCount || systemWide);
            this.value = new IAnalysisHardwareCounterReader.Value(channelBase + (systemWide ? 0 : streamValue.deviceNo), streamValue.index.timestamp, streamValue.index.sequenceNo, streamValue.duration, streamValue.utid, streamValue.value);
        }

        @Override
        public long getSequenceNo() {
            return this.value.sequenceNo;
        }

        @Override
        public long getTimestamp() {
            return this.value.timestamp;
        }
    }

    public static final class VmStream
    implements IThrowingSupplier<StreamValue, IOException> {
        private final int channelBase;
        private final int deviceNoCount;
        private final boolean systemWide;
        private final @NonNull StreamValueIterator<CounterStreamParser.StreamValue> valueIterator;

        public VmStream(int channelBase, int deviceNoCount, boolean systemWide, @NonNull List<@NonNull L0IndexEntry> l0Index, @NonNull IFileDataView dataFileView) throws IOException {
            this.channelBase = channelBase;
            this.deviceNoCount = deviceNoCount;
            this.systemWide = systemWide;
            this.valueIterator = new StreamValueIterator<CounterStreamParser.StreamValue>(dataFileView, L1IndexIterator.createFromL0Index(dataFileView, l0Index), new CounterStreamParser());
        }

        public @Nullable StreamValue get() throws IOException {
            if (!this.valueIterator.hasNext()) {
                return null;
            }
            return new StreamValue(this.channelBase, this.deviceNoCount, this.systemWide, this.valueIterator.next());
        }
    }
}

