/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsPerChannelReader;
import com.arm.streamline.analysis.database.stream.UtidToLong;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.AnnotationsStreamParser;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.analysis.model.AnnotationType;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseAnnotationPerChannelEventReader
implements IAnalysisAnnotationsPerChannelReader {
    private final @NonNull IFileDataView dataFileView;
    private int idCounter = 0;
    private final @NonNull TLongObjectMap<TLongObjectMap<TIntIntMap>> idMap = new TLongObjectHashMap(0, 0.5f, -1L);
    private final @NonNull List<@NonNull L0IndexEntry> l0Entries;
    private StreamValueIterator<AnnotationsStreamParser.StreamValue> valueIterator;
    private final long vmUID;

    public DatabaseAnnotationPerChannelEventReader(long vmUID, @NonNull List<@NonNull L0IndexEntry> l0Entries, @NonNull IFileDataView dataFileView) throws IOException {
        this.vmUID = vmUID;
        this.l0Entries = l0Entries;
        this.dataFileView = dataFileView;
        this.valueIterator = null;
    }

    @Override
    public void close() throws IOException {
        this.valueIterator = null;
    }

    @Override
    public @Nullable IAnalysisAnnotationsPerChannelReader.Value read() throws IOException {
        if (this.valueIterator == null) {
            this.valueIterator = new StreamValueIterator<AnnotationsStreamParser.StreamValue>(this.dataFileView, L1IndexIterator.createFromL0Index(this.dataFileView, this.l0Entries), new AnnotationsStreamParser());
        }
        if (!this.valueIterator.hasNext()) {
            return null;
        }
        @NonNull AnnotationsStreamParser.StreamValue parsedval = this.valueIterator.next();
        int utid = (int)UtidToLong.mapUtid(parsedval.utid);
        switch (parsedval.type) {
            case BOOKMARK: {
                return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.BOOKMARK, utid, parsedval.index.timestamp, -1, null, -1, null, parsedval.text, parsedval.color, null);
            }
            case NAME_CHANNEL: {
                return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.CHANNEL_NAME, utid, parsedval.index.timestamp, this.mapId(utid, parsedval.domain, parsedval.group), parsedval.group, this.mapId(utid, parsedval.domain, parsedval.channel), parsedval.channel, parsedval.name, -1, parsedval.image);
            }
            case NAME_GROUP: {
                return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.GROUP_NAME, utid, parsedval.index.timestamp, this.mapId(utid, parsedval.domain, parsedval.group), parsedval.group, -1, null, parsedval.name, -1, null);
            }
            case TEXT: {
                return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.STRING, utid, parsedval.index.timestamp, -1, null, this.mapId(utid, parsedval.domain, parsedval.channel), parsedval.channel, parsedval.text, parsedval.color, null);
            }
            case VISUAL: {
                return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.VISUAL, utid, parsedval.index.timestamp, -1, null, -1, null, "", -1, parsedval.image);
            }
        }
        throw new IOException("unsupported annotation type " + String.valueOf((Object)parsedval.type));
    }

    private int mapId(long utid, long domain, int id) {
        int result;
        TIntIntMap iMap;
        TLongObjectMap dMap = (TLongObjectMap)this.idMap.get(utid);
        if (dMap == null) {
            dMap = new TLongObjectHashMap(0, 0.5f, -1L);
            this.idMap.put(utid, (Object)dMap);
        }
        if ((iMap = (TIntIntMap)dMap.get(domain)) == null) {
            iMap = new TIntIntHashMap(0, 0.5f, -1, -1);
            dMap.put(domain, (Object)iMap);
        }
        if ((result = iMap.adjustOrPutValue(id, 0, this.idCounter)) == this.idCounter) {
            ++this.idCounter;
        }
        return result;
    }
}

