/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.processing.CachingStreamReaderAdapter;
import com.arm.utils.function.IThrowingSupplier;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractDatabaseVmStreamReader<V, T extends IStreamValue> {
    private int searchCount;
    private int searchIndex = 0;
    private final @NonNull List<@NonNull CachingStreamReaderAdapter<T>> vmStreams;

    public <S extends IThrowingSupplier<T, IOException>> AbstractDatabaseVmStreamReader(@NonNull List<@NonNull S> vmStreams) {
        this.vmStreams = vmStreams.stream().map(CachingStreamReaderAdapter::new).collect(Collectors.toList());
        this.searchCount = vmStreams.size();
    }

    protected final @Nullable V doRead() throws IOException {
        int leadingEmptyStreams = 0;
        int trailingEmptyStreams = 0;
        int bestIndex = 0;
        IStreamValue bestValue = null;
        int i = 0;
        while (i < this.searchCount) {
            CachingStreamReaderAdapter<T> stream = this.vmStreams.get(i + this.searchIndex);
            IStreamValue value = (IStreamValue)stream.head();
            if (value == null) {
                if (i == leadingEmptyStreams) {
                    ++leadingEmptyStreams;
                }
                ++trailingEmptyStreams;
            } else {
                trailingEmptyStreams = 0;
                if (bestValue == null || value.getTimestamp() < bestValue.getTimestamp() || value.getTimestamp() == bestValue.getTimestamp() && value.getSequenceNo() < bestValue.getSequenceNo()) {
                    bestIndex = i + this.searchIndex;
                    bestValue = value;
                }
            }
            ++i;
        }
        if (bestValue == null) {
            this.searchCount = 0;
            return null;
        }
        assert (leadingEmptyStreams < this.searchCount);
        assert (trailingEmptyStreams < this.searchCount);
        assert (leadingEmptyStreams + trailingEmptyStreams < this.searchCount);
        this.searchCount -= leadingEmptyStreams + trailingEmptyStreams;
        this.searchIndex += leadingEmptyStreams;
        this.vmStreams.get(bestIndex).next();
        return this.mapStreamValue(bestValue);
    }

    protected abstract @NonNull V mapStreamValue(@NonNull T var1);

    public static interface IStreamValue {
        public long getSequenceNo();

        public long getTimestamp();
    }
}

